<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Models\User;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    
    public function resolveDefaultRoute()
    {
        //Treba redirectovati ulogovanog korisnika na odredjeno mesto
        $user = auth()->user();

        if (!$user instanceof User) {
            abort(403);
        }

        if ($user) {
            return redirect()->route('truck.truck_finance');
        }
        
        
    }
}
