<?php

namespace App\Http\Controllers;

//change the request class if needed
use Illuminate\Http\Request as Request;

use App\Models\Truck\Truck as Entity;
use App\Models\Website\Website;

use Junges\ACL\Models\Group;

use App\Http\Resources\Select2\Role;
use Illuminate\Validation\Rule;

use App\Http\Resources\JsonResource;
use App\Models\Truck\Company;
use App\Models\Truck\CompanyProcurement;
use App\Models\Truck\Invoice;
use App\Models\Truck\InvoicePayment;
use App\Models\Truck\InvoiceProcurement;
use Illuminate\Support\Carbon;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class TruckFController extends Controller 
{
    protected $request;
    
    public function __construct(Request $request)
    {
        $this->request = $request;

    }
    
    public function index()
{   
    $currentYear = now()->year;
    $currentMonth = now()->month;

    // 1. Number of invoices with status 1 in 2024
    $invoicesStatus1 = Invoice::whereYear('date_end', $currentYear)
                              ->where('status', 1)
                              ->count();

    // 2. Number of invoices with status 0 in 2024
    $invoicesStatus0 = Invoice::whereYear('date_end', $currentYear)
                              ->where('status', 0)
                              ->count();


     // 1. Number of invoices with status 1 in 2024
     $procurementStatus1 = InvoiceProcurement::whereYear('date_end', $currentYear)
        ->where('status', 1)
        ->count();

// 2. Number of invoices with status 0 in 2024
    $procurementStatus0 = InvoiceProcurement::whereYear('date_end', $currentYear)
        ->where('status', 0)
        ->count();
   
        // 3. Total number of invoices in 2024
    $invoicesTotal = Invoice::whereYear('date_end', $currentYear)
                            ->count();
    $procurementTotal = InvoiceProcurement::whereYear('date_end', $currentYear)
    ->count();

    // 4. Number of invoices this month
    $invoicesThisMonth = Invoice::whereYear('date_end', $currentYear)
                                ->whereMonth('date_end', $currentMonth)
                                ->count();

    $procurementThisMonth = InvoiceProcurement::whereYear('date_end', $currentYear)
    ->whereMonth('date_end', $currentMonth)
    ->count();

    $potrosnja = InvoiceProcurement::where('status', 1)->where('currency', 'KM')->sum('price');
    $zarada = Invoice::where('status', 1)->where('currency', 'KM')->sum('debt');

    return view('truck.finances', [
        'invoicesStatus1' => $invoicesStatus1,
        'invoicesStatus0' => $invoicesStatus0,
        'procurementStatus1' => $procurementStatus1,
        'procurementStatus0' => $procurementStatus0,
        'invoicesTotal' => $invoicesTotal,
        'procurementTotal' => $procurementTotal,
        'invoicesThisMonth' => $invoicesThisMonth,
        'procurementThisMonth' => $procurementThisMonth,
        'zarada' => $zarada,
        'potrosnja' => $potrosnja
    ]);
}
    
    public function companyPaid()
    {   
        $companies = Company::all();
        return view('truck.company_paid', ['companies' => $companies]);
    }

    public function getInvoices(Request $request)
    {
        $companyId = $request->id;

        $invoices = Invoice::where('company', $companyId)
                    ->whereNull('deleted_at')
                    ->where('status', 0)
                    ->get();

        return response()->json(['invoices' => $invoices]);
    }

    public function addNewPayment(Request $request){
        
        $companyId = $request->input('company');
        $reference = $request->input('reference');
        $currency = $request->input('currency');
        $dateStart = $request->input('date_start');
        $price = (float) $request->input('price');

        // Pronađi neplaćene fakture za datu kompaniju
        $invoices = Invoice::where('company', $companyId)
                    ->whereNull('deleted_at')
                    ->where('status', 0)
                    ->orderBy('created_at', 'asc') // Redosled da bi prvo obrađivali starije fakture
                    ->get();


        foreach ($invoices as $invoice) {
            if ($price <= 0) {
                break; // Ako nema više novca za plaćanje, izađi iz petlje
            }
    
            $invoiceAmount = (float) $invoice->price;
    
            if ($price >= $invoiceAmount) {
                // Ako imamo dovoljno novca za potpuno plaćanje fakture
                $invoice->status = 1; // Faktura je plaćena
                $invoice->price_part = 0;
                $invoice->save();
                $price -= $invoiceAmount; // Oduzmi iznos fakture od ukupnog novca
            } else {
                // Ako imamo samo delimično novca za plaćanje fakture
                $invoice->price_part = $invoice->price_part + $price; // Upisujemo delimično plaćen iznos
                $invoice->debt = $invoice->debt + ($invoice->price - $invoice->price_part);
                $invoice->save();
                $price = 0; // Sve preostale vrednosti su isplaćene
            }
        }
    
        if ($price > 0) {
            // Pronađi kompaniju i dodaj preostali novac u 'extra_money'
            $company = Company::find($companyId);
        
            if ($company) {
                // Pretpostavljamo da `extra_money` polje postoji u modelu Company
                $company->extra_money += $price; // Dodaj preostali novac
                $company->save();
            }
        }

        // Kreiraj novi zapis u tabeli invoice_payment
        InvoicePayment::create([
            'company' => $companyId,
            'price' => $request->input('price'),
            'currency' => $currency,
            'date_start' => $dateStart,
            'reference' => $reference,
        ]);


        
        return redirect()->route('truck_finance_invoice_payments')->withSystemSuccess(__('Uplata je uspešno sačuvana!'));
    }

    public function datatable(Request $request)
    {
        $dateStart = Carbon::parse($request->date_start)->format('Y-m-d');
        $query = Invoice::query()
            ->where('status', 0)
            ->whereDate('date_end', $dateStart)
            ->orderBy('created_at', 'desc');


        $datatables = datatables($query)
            ->editColumn('price', function ($entity) {
                if ($entity->price_part > 0) {
                    return $entity->price .' ' . $entity->currency . ' (<span class="price-part-green">' . $entity->price_part . ' uplaceno</span>) ';
                } else {
                    return $entity->price . ' ' . $entity->currency;
                }
                
            })->editColumn('company', function ($entity) {
                $company = Company::where('id', $entity->company)->first();    
                return $company['name'];  
            })->rawColumns(['price'])
            ->setRowAttr([
                'data-id' => function($entity) {
                    return $entity->id;
                }
            ])
            ->make(true);

        $datatables = $datatables->getData(true);

        return response()->json($datatables);
    } 
    public function datatable1(Request $request)
    {
        $dateStart = Carbon::parse($request->date_start1)->format('Y-m-d');
        $query = InvoiceProcurement::query()
            ->where('status', 0)
            ->whereDate('date_end', $dateStart)
            ->orderBy('created_at', 'desc');


        $datatables = datatables($query)
            ->editColumn('price', function ($entity) {
                if ($entity->price_part > 0) {
                    return $entity->price .' ' . $entity->currency . ' (<span class="price-part-green">' . $entity->price_part . ' uplaceno</span>) ';
                } else {
                    return $entity->price . ' ' . $entity->currency;
                }
                
            })->editColumn('company', function ($entity) {
                $company = CompanyProcurement::where('id', $entity->company)->first();    
                return $company['name'];  
            })->rawColumns(['price'])
            ->setRowAttr([
                'data-id' => function($entity) {
                    return $entity->id;
                }
            ])
            ->make(true);

        $datatables = $datatables->getData(true);

        return response()->json($datatables);
    } 
}
