<?php

namespace App\Http\Controllers;

//change the request class if needed
use Illuminate\Http\Request as Request;

use App\Models\Truck\Truck as Entity;
use App\Models\Website\Website;

use Junges\ACL\Models\Group;

use App\Http\Resources\Select2\Role;
use Illuminate\Validation\Rule;

use App\Http\Resources\JsonResource;
use Illuminate\Support\Carbon;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class TruckTrucksController extends Controller 
{
    protected $request;
    
    public function __construct(Request $request)
    {
        $this->request = $request;

    }
    
    public function index()
    {   
        return view('truck.trucks.index');
    }
    
    /*
     * Yajrabox datatables metod
     */
    public function datatable()
    {
        $query = Entity::query()->where('id', '>', 0)->orderBy('created_at', 'desc');

        return datatables($query)
            ->addColumn('actions', function ($entity) {
                return view('truck.trucks.partials.table.actions', 
                            ['entity' => $entity]);
            })
            ->addColumn('image', function ($entity) {
                return view('truck.trucks.partials.table.image', 
                            ['entity' => $entity]);
            })
            
            ->editColumn('phone', function ($entity) {
                return $entity-> phone ? $entity->phone : '---';
            })
           
            ->rawColumns(['actions', 'image'])
            ->setRowAttr([
                'data-id' => function($entity) {
                    return $entity->id;
                }
            ])
            ->make(true);
    }
    
    public function create()
    {   
        $entity = new Entity();
        
        return view('truck.trucks.create', [
            'entity' => $entity,
        ]);
    }
    
    public function store()
    {   
        $request = $this->request;
        
        $data = $request->validate([
            'producer' => ['required', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:100'],
            'traffic_number' => ['required', 'string', 'max:20'],
            'number_of_plates' => ['required', 'string', 'max:10']
        ]);

        $entity = new Entity();
        $entity->fill($data);
        $entity->save();
        
        
        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Vozač je uspešno sačuvan!'));
        }
        
        return redirect()->route('truck.trucks')->withSystemSuccess(__('Vozač je uspešno sačuvan!'));
    }
    
    public function edit(Entity $entity)
    {
            return view('truck.trucks.edit', [
            'entity' => $entity,
        ]);
    }
    
    public function update(Entity $entity)
    {
        $request = $this->request;
        
        $data = $request->validate([
            'producer' => ['required', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:100'],
            'traffic_number' => ['required', 'string', 'max:20'],
            'number_of_plates' => ['required', 'string', 'max:10']
        ]);
        
        $entity->fill($data);
        $entity->save();
        
        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Vozač je uspešno izmenjen!'));
        }
        
        return redirect()->route('truck.trucks')->withSystemSuccess(__('Vozač je uspešno izmenjen!'));
    }
    
    public function delete(Entity $entity)
    {
        $entity->delete();
        
        if ($this->request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Vozač je uspešno obrisan!'));
        }
        
        return redirect()->route('truck.trucks.index')->withSystemSuccess(__('Vozač je uspešno obrisan!'));
    }

}
