<?php

namespace App\Http\Requests;

use App\Rules\SubcategoryLevelRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SubcategoryRequest extends FormRequest
{


    /**
     * Vrati niz koji sadrzi validaciona pravila kojih mora da se pridrzava
     * slika pridruzena kategoriji.
     * 
     * @return array
     */
    private function getPhotoValidationRules()
    {
        return ['nullable', 'file', 'image','max:' . config('newscms.max_image_upload_size'), 
                'mimes:jpeg,bmp,png', Rule::dimensions()->minWidth(64)->minHeight(64)];
    }
    /**
     * Autorizacija se izvrsava preko 'middleware'-a. Zato je setovano 'TRUE' 
     * kao povratna vrednost.
     *
     * @return bool
     */
    public function authorize()
    {
        return TRUE;
    }

    /**
     * Validaciona pravila za akcije 'store/update' kontrolera 
     * CategoriesController
     *
     * @return array
     */
    public function rules()
    {
        return [
            'parent_id' => ['required', 'integer', 'exists:categories,id', new SubcategoryLevelRule()],
            'name' => ['required', 'string', 'min:3', 'max:255'],
            'color' => ['required', 'string', 'min:7', 'max:7'],
            'logo' => $this->getPhotoValidationRules(),
            'main_image' => $this->getPhotoValidationRules(),
            'seo_title' => ['required', 'string', 'min:3', 'max:255'],
            'seo_description' => ['required', 'string', 'min:3', 'max:255'],
            'seo_keywords' => ['required', 'string', 'min:3', 'max:255'],
            'subcategory_list' => ['string', 'in: 0, 1'],
            'program_list' => ['string', 'in: 0, 1'],
        ];
    }
}
