<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Models\Website\Website as Entity;

class WebsitePolicy
{
    use HandlesAuthorization;

    public function before(User $user, $ability)
    {
//        if (optional($user)->hasPermission('admin')) {
//            //return true ako korisnik ima privilegije za admin sekciju i u njoj da menja poslovne jedinice 
//            return true;
//        }
        
        if (!optional($user)->hasPermission('website')) {
            // Ako korisnik nema privilegija za sekciju website ne treba da se dozvoli pristup
            return false;
        }
        //Na dalje treba da se proveri da li je korisniku dodeljen website
    }
    
    public function access(User $user, Entity $entity)
    {
        //TODO proveriti da li korisnik ima dodeljenu odredjenu poslovnu jedinicu ili ne
        
        if(in_array($entity->id, $user->websites->pluck('id')->toArray())){
            return true; 
        }
    }
}
