( function() {
	CKEDITOR.plugins.add( 'bridVideo', {
		icons: 'bridVideo', // %REMOVE_LINE_CORE%
		hidpi: true, // %REMOVE_LINE_CORE%
		init: function(editor) {
			var bridVideo = this;
            var bridVideoModal = getBridVideoModal();

            editor.addCommand('bridVideo', {
            	exec: function(editor) {

					//setuj kod otvaranja modala da se radi o ckeditorVideoModal-u
					$('#leadVideoModal').attr('data-action', 'ckeditorVideoModal')
					//pozivanje ajax rute za inicijalni prikaza video materijala sa parametrima
					let term = $('#leadVideoModal input[name="search_video"]').val();
                    let videosNumber = $('#leadVideoModal [name="articles_number"]').val();
                    let page = $('#leadVideoModal [name="page"]').val();

                    $.ajax({
                        url: "/articles/ajax-get-searched-videos",
                        type: "get",
                        data: {
                            term: term,
                            videosNumber: videosNumber,
                            page: page
                        }
                    }).done(function(response) {
                        $('#leadVideoModal div.video-articles-loader').hide();
                        $('#leadVideoModal #videos').html(response);
                        
                    }).fail(function(jqXHR, textStatus, errorThrown){
                        // $('#leadVideoModal #videos').html('<p>@lang('Nije pronadjen nijedan video')</p>');
					});
					
					//dugme dodaj na koje se ubacuje video u ckeditor
					$('#leadVideoModal').on('click.MyVideoEvent', 'div.list-videos-actions a', function(e){
						e.preventDefault();
						
						let id = $(this).data('video-id');
						
						let html = `<p><img alt="" v_id="${id}" src="/custom/ckeditor/plugins/bridVideo/brid-video.png" data-brid-video="${id}" style="display: block; width: 100%;"/></p>`;

						editor.insertHtml(html);
                        editor.focus();

					});

					$('#leadVideoModal').on('keypress.MyKeyPressEvent', 'input.quick-video-entry', function(e) {
						let code = e.keyCode || e.which;
						if (code == 13) {
							if($('#leadVideoModal').attr('data-action') === 'ckeditorVideoModal'){
								let term = $(this).val();
								let videosNumber = $('#leadVideoModal [name="articles_number"]').val();
                    			let page = $('#leadVideoModal [name="page"]').val();
								//stara logika za brzi unos bez prikazivanja video materijala
								// $.ajax({
								// 	url: "/articles/ajax-check-brid-exists",
								// 	type: "get",
								// 	data: {
								// 		videoId: id
								// 	}
								// }).done(function(response) {
								// 	if(response.data === false){
								// 		showSystemMessage(response.error, 'error');
								// 	}else{
								// 		let html = `<p><img alt="" v_id="${id}" src="/custom/ckeditor/plugins/bridVideo/brid-video.png" data-brid-video="${id}" style="display: block; width: 100%;"/></p>`;
								// 		editor.insertHtml(html);
								// 		editor.focus();
								// 		$('#leadVideoModal').modal('hide');
								// 	}
									
								// }).fail(function(jqXHR, textStatus, errorThrown){
								// 	// $('#leadVideoModal #videos').html('<p>@lang('Nije pronadjen nijedan video')</p>');
								// });
								//nova logika za brzi unos gded dobijemo rezultat pretrage pa tek na dugme ubaci ubacujemo video
								$.ajax({
									url: "/articles/ajax-get-searched-videos",
									type: "get",
									data: {
										term: term,
										videosNumber: videosNumber,
										page: page,
										search_brid: true
									}
								}).done(function(response) {
									$('#leadVideoModal div.video-articles-loader').hide();
									$('#leadVideoModal #videos').html(response);
									
								}).fail(function(jqXHR, textStatus, errorThrown){
									// $('#leadVideoModal #videos').html('<p>@lang('Nije pronadjen nijedan video')</p>');
								});
								
								//dugme dodaj na koje se ubacuje video u ckeditor
								//posle izmene logike za brzi unos zbog ovog koda video se dva puta dodavao
								// $('#leadVideoModal').on('click.MyVideoEvent', 'div.list-videos-actions a', function(e){
								// 	e.preventDefault();
									
								// 	let id = $(this).data('video-id');
									
								// 	let html = `<p><img alt="" v_id="${id}" src="/custom/ckeditor/plugins/bridVideo/brid-video.png" data-brid-video="${id}" style="display: block; width: 100%;"/></p>`;
			
								// 	editor.insertHtml(html);
								// 	editor.focus();
			
								// });
								
							}
						}
					});

                	bridVideoModal.openModal(null, function() {
                    	editor.focus();
					});
            	}
            });

            editor.ui.addButton( 'BridVideo', {
                label: 'Brid Video',
                command: 'bridVideo',
                icon: 'bridVideo',
                toolbar: 'relatedArticles'
			});
			
			editor.on('doubleclick', function (evt) {
                var element = evt.data.element;

                if (element && element.is('img')) {
                    if (element.hasAttribute('data-brid-video')) {
						evt.cancel();
                        editor.execCommand('bridVideo');
                    }
                }
            });

            if (editor.contextMenu) {
            	editor.addMenuGroup('bridVideo');

        		editor.contextMenu.addListener(function(element, selection) {

        			if (element.hasAttribute('data-brid-video')) {
						editor.contextMenu.removeAll();
        				editor.addMenuItems({
        					BridVideoEdit: {
        	                   label : 'Izmeni Brid Video',
        	                   icon: 'bridVideo',
        	                   command : 'bridVideo',
        	                   group : 'bridVideo',
        	                   order : 1
							},
							DeleteLatestDiv: {
        	                    label : 'Obriši okvir',
        	                    command : 'deleteLatestDiv',
        	                    group : 'news',
        	                    order : 2
        					}
        	            });

            			return {
							BridVideoEdit: CKEDITOR.TRISTATE_ON,
							DeleteLatestDiv: CKEDITOR.TRISTATE_ON
                        };
        			} else if (selection.getType() == CKEDITOR.SELECTION_NONE || selection.getType() == CKEDITOR.SELECTION_TEXT) {
        				editor.addMenuItems({
        					BridVideoInsert: {
        	                   label : 'Dodaj Brid Video',
        	                   icon: 'bridVideo',
        	                   command : 'bridVideo',
        	                   group : 'bridVideo',
        	                   order : 98
        					}
        	            });

            			return {
            				BridVideoInsert: CKEDITOR.TRISTATE_OFF
                        };
        			}
                });
        	}
        }
    });
})();
