@push('head_links')
<style>
    .newscms-daterangepicker {

    }
</style>
@endpush

@php
    $id = $id ?? ( 'datum-' . rand(1000, 9999) );

    $valueStart = $valueStart ?? '';
    $valueEnd = $valueEnd ?? '';

    if($valueStart && $valueEnd) {
        //$value = \Carbon\Carbon::parse($valueStart)->format('d.m.Y') . ' - ' . \Carbon\Carbon::parse($valueEnd)->format('d.m.Y'); // <- ukoliko nije Carbon
        $value = $valueStart->format('d.m.Y') . ' - ' . $valueEnd->format('d.m.Y');
        $valueStart = $valueStart->format('Y-m-d');
        $valueEnd = $valueEnd->format('Y-m-d');
    }
    else {
        $value = '';
    }
@endphp

<div class="newscms-daterangepicker">
    <input type="hidden" 
        id="{{ $id . '_od' }}"
        name="{{ $name_datum_od ?? ($name_datum_od = 'datum_od') }}"
        value="{{ $valueStart }}"
    >
    <input type="hidden" 
        id="{{ $id . '_do' }}"
        name="{{ $name_datum_do ?? ($name_datum_do = 'datum_do') }}"
        value="{{ $valueEnd }}"
    >
    <input type="text" 
           class="form-control input-limit-datepicker" 
           id="{{ 'drp-' . $id }}"
           value="{{ $value }}"
           placeholder="{{ $placeholder ?? __('Izaberite raspon datuma') }}"
           @if(isset($readonly) && $readonly) readonly @endif
           @if(isset($disabled) && $disabled) disabled @endif
           >
</div>

@push('after_footer_scripts')
<script>
$(function() {
    let drp = $("#{{ 'drp-' . $id }}");
    let drpOdHidden = $("#{{ $id . '_od' }}");
    let drpDoHidden = $("#{{ $id . '_do' }}");

    let ranges = {
        'Tekuća godina': [moment().startOf('year'), moment().endOf('year')],
        'Tekući mesec': [moment().startOf('month'), moment().endOf('month')],
        'Poslednjih 30 dana': [moment().subtract(30, 'days'), moment()],
        'Prethodni mesec': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    };
    
    @if(isset($enable_quarters) && $enable_quarters === true){
        ranges['Prvi kvartal'] = [moment().quarter(1).startOf('quarter'), moment().quarter(1).endOf('quarter')]
        ranges['Drugi kvartal'] = [moment().quarter(2).startOf('quarter'), moment().quarter(2).endOf('quarter')]
        ranges['Treći kvartal'] = [moment().quarter(3).startOf('quarter'), moment().quarter(3).endOf('quarter')]
        ranges['Četvrti kvartal'] = [moment().quarter(4).startOf('quarter'), moment().quarter(4).endOf('quarter')]
    }
    @endif
    
    @if(!empty($ranges))
    ranges = {
        @foreach($ranges as $range)
        '{{$range["label"]}}': [moment('{{$range["start"]}}'), moment('{{$range["end"]}}')]
        @if(!$loop->last)
        ,
        @endif
        @endforeach
    };
    @endif

    let config = $.extend({
        //format: 'MM.DD.YYYY', <- format je setovan dole u locale.format
        timePicker: false,
        ranges: ranges,
        opens: '{{isset($opens) ? $opens : "left"}}',
        drops: 'down',
        buttonClasses: ['btn', 'btn-sm'],
        applyClass: 'btn-success',
        cancelClass: 'btn-secondary',
        separator: ' - ',
        locale: {
            format: 'DD.MM.YYYY',
            applyLabel: 'Primeni',
            cancelLabel: 'Obriši',
            fromLabel: 'Od',
            toLabel: 'Do',
            customRangeLabel: 'Ručni unos',
            daysOfWeek: ['Ned', 'Pon', 'Uto', 'Sre', 'Čet', 'Pet', 'Sub'],
            monthNames: ['Januar', 'Februar', 'Mart', 'April', 'Maj', 'Jun', 'Jul', 'Avgust', 'Septembar', 'Oktobar', 'Novembar', 'Decembar'],
            firstDay: 1
        }
    }, @json($config ?? []));

    drp.daterangepicker(config, function (start, end, label) {
        if(start._isValid && end._isValid)
        {
            // setuj vrednost 'hidden' elemenata
            drpOdHidden.val(start.format('YYYY-MM-DD'));
            drpDoHidden.val(end.format('YYYY-MM-DD'));
        }
        else {
            console.log("Neispravan format datuma. Ignorisem.");
        }
    });

    // izbrisi vrednosti kada se klikne na 'cancel' (Obrisi)
    drp.on('cancel.daterangepicker', function(ev, picker) {
        drp.val('');
        drpOdHidden.val('');
        drpDoHidden.val('');
    });
    
    drp.on('apply.daterangepicker', function(ev, picker) {
        $("#{{ 'drp-' . $id }}").trigger( "newscms-daterangepicker-apply" );
    });

    // setuj inicijalnu vrednost koja se prikazuje
    drp.val("{{ $value }}");

    // Setuj vrednost 'hidden' elemenata (od, do) kada su oni prazani.
    // Uradjeno zbog posebnog slucaja kada je vrednost 'widget'-a prazna a 
    // korisnik klikne na prostor sa strane (prostor van 'widget'-a) jer se 
    // tada vrednost setuje u 'input'-u ali ne i u 'hidden' elementima.
    drp.on('change', function() {

        if(drpOdHidden.val() == '') {
            let daterangeVal = $(this).val();
            let dates = daterangeVal.split(' - ');

            if(dates.length == 2) {
                let momentObjOd = moment(dates[0], 'DD.MM.YYYY');
                let momentObjDo = moment(dates[1], 'DD.MM.YYYY');

                if(momentObjOd.isValid() && momentObjDo.isValid()) { 
                    drpOdHidden.val(momentObjOd.format('YYYY-MM-DD'));
                    drpDoHidden.val(momentObjDo.format('YYYY-MM-DD'));
                }
            }
            else {
                console.log("Greska! 'daterangepicker' datum je neispravan !");
            }
        }
    });

});
</script>
@endpush