@push('head_links')
<link href="{{asset('/theme/plugins/select2/css/select2.min.css')}}" rel="stylesheet" type="text/css" />
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<div class="row fileinput fileinput-new" data-provides="fileinput" id="{{$id ?? $id = 'image_upload_' . rand(1000, 9999)}}">
    <div class="col-lg-6">
        <label>{{$label ?? __('Slika')}}</label>
    </div>
    <div class="col-lg-6 text-right">
        <span class="btn btn-outline-primary btn-file">
            <span class="fileinput-new">
                @if(!empty($imageObj))
                @lang('Promeni sliku')
                @else
                @lang('Izaberi sliku')
                @endif
            </span>
            <span class="fileinput-exists">@lang('Druga slika')</span>
            <input type="file" name="{{$name ?? $id}}" @isset($form) form="{{$form}}" @endisset class="">
        </span>
        <span class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">@lang('Odustani')</span>
        @if(!empty($imageObj))
        <span 
            class="btn btn-outline-danger"
            data-action="delete-photo"
            data-title="@lang('Brisanje slike')"
            data-text="@lang('Da li ste sigurni da želite da obrišete sliku?')"
            data-image-class="{{ $imageObj->class }}"
            @if(isset($deleteImageAjaxUrl))
            data-ajax-url="{{$deleteImageAjaxUrl}}"
            @endif 
        >@lang('Obriši')</span>
        @endif
    </div>
    <div class="col-lg-12 text-center mt-4">
        <div class="fileinput-new img-thumbnail d-flex mx-auto" style="width: {{$width ?? '100'}}px; height: {{$height ?? '100'}}px;">
            <img data-src="{{!empty($imageObj) ? $imageObj->getUrl() : $defaultImageUrl}}"  
                src="{{!empty($imageObj) ? $imageObj->getUrl() : $defaultImageUrl}}" 
                alt="..."
                data-max-size="{{ config('newscms.max_image_upload_size') }}" 
                class="align-self-center">
        </div>
        <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: {{$width ?? '100'}}px; max-height: {{$height ?? '100'}}px;"></div>
    </div>
</div>

@push('footer_scripts')
<script>
(function () {
    
    var blade = {
        default_image_url : "{{ $defaultImageUrl }}"
    };


    var fileInput = $('input[name="{{$name ?? $id}}"]');

    // Zbog dodatih klasa 'd-flex' i 'mx-auto' "jasny" ne moze da postavi 'd-none' na
    // staru sliku nakon promene. Zato se te klase brisu nakon odabira druge slike.
    // 'd-flex' i 'mx-auto' zajedno sa 'align-self-center' centriraju sliku.
    fileInput.on('change', function() {
        $('#{{$id}}').find('.fileinput-new.img-thumbnail.d-flex.mx-auto')
                     .removeClass('d-flex')
                     .removeClass('mx-auto');
    });
    
    $('#{{$id}}').questionPop({
        liveSelector: '[data-action="delete-photo"]'
    }).on('success.qp', function (e) {
        let fileSelectContainer = $(e.target).closest('[data-provides="fileinput"]');
    
        fileSelectContainer.fileinput('reset');
        let origImage = fileSelectContainer.find('.fileinput-new img');
        console.log(origImage);
    
        origImage.attr('src', blade.default_image_url);
        origImage.data('src', blade.default_image_url);
        $(e.target).hide();
    });
  
})();
</script>
@endpush