@extends('_layout.layout')

@section('head_title', __('Grupe Korisnika') . ' - ' . __('Korisnici Programa'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Grupe Korisnika"),
    'breadcrumbs' => [
        route('groups.index') => __('Korisnici Programa')
    ]
])

<div class="row">
    <div class="col-md-12">
    <div class="card">
        <div class="card-heading d-flex justify-content-between">
            <div class="card-heading-title">
                <h3 class="card-title">@lang('Grupa Korisnika')</h3>
            </div>
            <div class="card-heading-actions">
                <a href="{{route('groups.create')}}" class="btn btn-primary">
                    <i class="fa fa-plus mr-2"></i>
                    @lang('Dodaj')
                </a>
                <!-- end:title-toolbar  -->
            </div>
        </div>
        <div class="card-body">
            <div class="material-datatables">
                <table id="entity-list-table" class="table table-striped table-no-bordered table-hover" cellspacing="0" width="100%" style="width:100%">
                <thead>
                    <tr>
                        <th>@lang('Ime')</th>
                        <th>@lang('Opis')</th>
                        <th class="disabled-sorting text-right">@lang('Opcije')</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div>
        <!-- end content-->
    </div>
    <!--  end card  -->
    </div>
    <!-- end col-md-12 -->
</div>
@endsection

@push('footer_scripts')
<script type="text/javascript">
    var table = $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: "@route('groups.datatable')",
            type: "POST",
        },
        "columns": [
            {"data": "name"},
            {"data": "description"},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
    });

    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });
</script>
@endpush