@push('head_scripts')
    <link href="{{asset('/theme/plugins/select2/css/select2.min.css')}}" rel="stylesheet" type="text/css" />
@endpush
<!-- begin:form -->
<style>
    .accordion .card{
    border: none
    }
    .accordion .card-heading{
    min-height: 40px
    }
    .card-heading .checkbox label, .card-heading .radio label{
    color:#fff;
    margin-bottom: 0;
    } 
</style>

<form id="groups-form" method="POST" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <div class="form-group row">
        <label class="col-md-2 control-label">
            @lang('Ime')
            <span class="text-danger">*</span>
        </label>
        <div class="col-md-6">
            <input type="text" name="name" value="{{old('name', $entity->name)}}" class="form-control" placeholder="@lang('Enter a Name')" autofocus maxlength="100">
            @formError(['field' => 'name'])
        </div>
    </div>
    <div class="form-group row">
        @unless (empty($permissions))
            <label class="col-md-2 control-label">
                @lang('Permisije')
                <span class="text-danger">*</span>
            </label>
            <div class="col-md-6">
                <div class="accordion" id="accordion-test-2">
                    @foreach ($permissions as $key => $permissionGroup)
                        <div class="card mb-2">
                            @if($permissionGroup['id'] != 'korisnici_programa' || !auth()->user()->hasGroup($entity->slug))
                                <div class="card-heading">
                                    <div class="checkbox d-inline-block">
                                        <label>
                                            <input class="collapsed" 
                                                   data-toggle="collapse" 
                                                   data-target="#group-{{$permissionGroup['id']}}" 
                                                   aria-controls="group-{{$permissionGroup['id']}}" 
                                                   type="checkbox" 
                                                   name="permissions[{{$permissionGroup['id']}}][]" 
                                                   value="{{$permissionGroup['children'][0]['id']}}" 
                                                   @if (in_array($permissionGroup['children'][0]['id'], $usedPermissions)) checked @endif>
                                            <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                            {{$permissionGroup['children'][0]['text']}}
                                        </label>
                                    </div>
                                </div>
                            @else
                                <div class="card-heading">
                                    <div class="checkbox d-inline-block">
                                        <label>
                                            <input class="collapsed" 
                                                   disabled=""
                                                   data-toggle="collapse" 
                                                   data-target="#group-{{$permissionGroup['id']}}" 
                                                   aria-controls="group-{{$permissionGroup['id']}}" 
                                                   type="checkbox" 
                                                   name="permissions[{{$permissionGroup['id']}}][]" 
                                                   value="{{$permissionGroup['children'][0]['id']}}" 
                                                   @if (in_array($permissionGroup['children'][0]['id'], $usedPermissions)) checked @endif>
                                            <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                            {{$permissionGroup['children'][0]['text']}}
                                        </label>
                                    </div>
                                </div>
                            @endif
                            <div id="group-{{$permissionGroup['id']}}" 
                                 class="collapse @if (in_array($permissionGroup['children'][0]['id'], $usedPermissions)) show @endif" 
                                 >
                                @if(count($permissionGroup['children']) > 1)
                                <div class="card-body py-0 text-right">
                                    <div class="checkbox d-inline-block">
                                        <label>
                                            <input type="checkbox" name="permissions[{{$permissionGroup['id']}}][]children" value="*">
                                            <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                            @lang('Izaberi sve')
                                        </label>
                                    </div>
                                </div>
                                @endif
                                <div class="card-body">
                                        @foreach (array_slice($permissionGroup['children']->toArray(), 1) as $permission)
                                            @if($permission['text'] != "Grupe"  || !auth()->user()->hasGroup($entity->slug))
                                                <div class="checkbox d-inline-block col-md-5">
                                                    <label>
                                                        <input type="checkbox" name="permissions[{{$permissionGroup['id']}}][]children" value="{{$permission['id']}}" @if (in_array($permission['id'], $usedPermissions)) checked @endif>
                                                        <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                        {{$permission['text']}}
                                                    </label>
                                                </div>
                                                &nbsp;
                                            @else
                                                <div class="checkbox d-inline-block col-md-5">
                                                    <label>
                                                        <input disabled="" checked="" type="checkbox" name="permissions[{{$permissionGroup['id']}}][]" value="{{$permission['id']}}" @if (in_array($permission['id'], $usedPermissions)) checked @endif>
                                                        <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                        {{$permission['text']}}
                                                    </label>
                                                </div>
                                                &nbsp;
                                            @endif
                                        @endforeach
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endunless
        @formError(['field' => 'permissions'])
    </div>
    <div class="form-group row">
        <label class="col-md-2 control-label">
            @lang('Opis')
        </label>
        <div class="col-md-6">
            <textarea name="description" placeholder="@lang('Enter a description')" class="form-control" rows="5" maxlength="655">{{old('description', $entity->description)}}</textarea>
            @formError(['field' => 'description'])
        </div>
    </div>
    <div class="form-group row">
        <div class="offset-md-2 col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>
<!-- end:form -->
@push('footer_scripts')
    <!-- begin:page script -->
    <script src="{{asset('/theme/plugins/select2/js/select2.min.js')}}"></script>
    <script src="{{asset('/theme/plugins/bootstrap-maxlength/bootstrap-maxlength.min.js')}}"></script>
    <script type="text/javascript">
        $('#groups-form textarea').maxlength({
            threshold: 655,
            placement: 'right'
        });

        $('#groups-form :text').maxlength({
            threshold: 100,
            placement: 'right'
        });

        $('input[name^=permissions]').change(function(e) {
            let $t = $(this);
            let thisPermissionGroup = $(`input[name="${$t.attr('name')}"]`);
            if($(this).val() == '*') {
                thisPermissionGroup.prop('checked', $t.prop('checked'));
            } else if($(this).attr('data-toggle') == 'collapse') {
                $(`input[name="${$t.attr('name')}children"]`).prop('checked', false);
            } else {
                let total = thisPermissionGroup.length;
                let checkedTotal = $(`input[name="${$t.attr('name')}"]:checked`).length;
                if(total != checkedTotal) {
                    $(`input[name="${$t.attr('name')}"][value="*"]`).prop('checked', false);
                }
            }
        });

        $("#groups-form").validate({
            rules: {
                name: {
                    required: true,
                    rangelength: [3, 100]
                },
                permissions: {
                    required: true
                },
                description: {
                    required: false,
                    rangelength: [10, 655]
                }
            }
        });

        $('#groups-form').submit(function(e) {
            $(`input[value="*"]`).remove();
        });
    </script>
    <!-- begin:page script -->
@endpush