<div class="card">
    <div class="card-heading d-flex justify-content-between">
        <div class="card-heading-title">
            <h3 class="card-title">@lang('Lista statičkih stranica')</h3>
            <p class="card-sub-title text-muted">@lang('Mozete da menjate <code>redosled</code> statičkih stranica po prioritetu')</p>
        </div>
        <div class="card-heading-actions">
            <form 
                action=""
                method="post"
                id="priority-change-form" 
                class="d-inline"
            >
                @csrf
                <input type="hidden" name="ids_by_priority" value="">

                <button id="priority-change-btn" type="button" class="btn btn-outline-warning">
                    <i class="fa fa-sort"></i>
                    @lang('Promeni Redosled')
                </button>
                <button id="priority-save-btn" type="button" class="btn btn-success" style="display: none;">
                    <i class="fa fa-save"></i>
                    @lang('Sačuvaj Redosled')
                </button>
                <button id="priority-cancel-btn" type="button" class="btn btn-outline-danger" style="display: none;">
                    <i class="fa fa-remove"></i>
                    @lang('Otkaži')
                </button>
            </form>
        </div>
    </div>
    <div class="card-body">
        <table id="entities-table" class="table table-striped">
            <thead>
                <tr>
                    <th>&nbsp;</th>
                    <th class="text-center"><span class="text-success"><i class="fa fa-check"></i></span></th>
                    <th>@lang('Naziv statičke stranice')</th>
                    <th class="text-center">@lang('Akcije')</th>
                </tr>
            </thead>
            <tbody>
                {{-- Podaci preko 'datatables'-a --}}
            </tbody>
        </table>
    </div>
</div>

@push('head_links')
<style>
    .sortable-move-highlight {
        background-color: rgba(0,0,0,0.1) !important;
        line-height: 2.8em;
    }
    .ui-sortable-helper > td {
        border: none !important; 
    }
    .table-sortable tbody tr:nth-of-type(odd) {
        background-color: rgba(255,255,255,0.1);
    }
</style>
@endpush

@push('footer_scripts')
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="{{asset('/theme/plugins/tiny-editable/mindmup-editabletable.js')}}"></script>
<script src="{{asset('/theme/assets/pages/jquery.datatables.editable.init.js')}}"></script>
<script>
$(function () {
    var blade = {
        prioritySaveAjaxUrl: "{{ route('pages.change_priority') }}",
        datatablesAjaxUrl: "{{ route('pages.datatable') }}"
    };

    // 'enter' kao 'tab'
    // @link https://stackoverflow.com/questions/1009808/enter-key-press-behaves-like-a-tab-in-javascript
    $('body').on('keydown', 'input, select', function(e) {
        if (e.key === "Enter") {
            var self = $(this), form = self.parents('form:eq(0)'), focusable, next;
            focusable = form.find('input,a,select,button,textarea').filter(':visible');
            next = focusable.eq(focusable.index(this)+1);
            if (next.length) {
                next.focus();
            } else {
                form.submit();
            }
            return false;
        }
    });
    
    // DATATABLES
    var datatable = $('#entities-table').DataTable({
        "processing": false,
        "serverSide": true,
        "paging": false,
        "language": {
            "emptyTable": "@lang('Nema media kategorija')",
            "sInfoFiltered": ""
        },
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post"
        },
        "columns": [
            {data: "sort_handle", orderable: false, searchable: false, className: "text-center", visible: false},
            {"data": "ban", className: "text-center"},
            {data: "title", orderable: false, searchable: true, className: "editable"}, 
            {data: "actions", orderable: false, searchable: false, className: "text-right"}
        ],
        createdRow: function( row, data, dataIndex ) {
            $(row).find('td.editable').attr('tabindex', 1);//.addClass('text-primary font-weight-bold');
        },
        "initComplete": function() {
            fixDatatableBug();      
        }
    });
    
    /**
     * Ispravi 'datatables' bag gde se pojavljuje fantomska klasa 'sorting_asc' 
     * iako je kolona setovana kao 'orderable: false'.
     */
    function fixDatatableBug()
    {
        $('th.sorting_asc').first().removeClass('sorting_asc');
    }

    // KOD ZA IZMENU REDOSLEDA ('PRIORITY') KATEGORIJA
    // ------------------------------------------------

    /**
     * Sakrij dugmice za 'save' i 'cancel' a prikazi za 'priority change'.
     * Uradi 'unbind' 'sortable' elementa.
     */
    function buttonsResetAndUnbindSortable() {
        $('#priority-change-btn').show();
        $('#priority-save-btn').hide();
        $('#priority-cancel-btn').hide();

        $(".sortable-entities").sortable("destroy");
        $('#entities-table_wrapper').removeClass('sortable-entities');
        $('#entities-table').switchClass("table-sortable", "table-striped");
    }

    $('#priority-change-btn').on('click', function () {
        $('#priority-change-btn').hide();
        $('#priority-save-btn').show();
        $('#priority-cancel-btn').show();

        $('#entities-table').switchClass("table-striped", "table-sortable", {children: true, duration: 600});
        $('#entities-table_wrapper').addClass('sortable-entities');

        //inicijalizuj 'jquery-ui sortable'
        $(".sortable-entities").sortable({ 
            items: "tr",
            containment: $('#entities-table > tbody'),
            handle: '.entity-sort-handle',
            tolerance: "pointer",
            placeholder: "sortable-move-highlight",
            cursor: "move",
            revert: 250, 
            // 'helper' resenje preuzeto sa -> https://stackoverflow.com/questions/1307705/jquery-ui-sortable-with-table-and-tr-width
            helper: function(e, tr) { 
                var $originals = tr.children();
                var $helper = tr.clone(true);
                $helper.children().each(function(index) {
                    // Set helper cell sizes to match the original sizes
                    $(this).width($originals.eq(index).width());
                });
                return $helper;
            }
        });

        // prikazi kolonu sa 'sorting hadle' elementima
        datatable.column(0).visible(true);
        fixDatatableBug();
    });

    $('#priority-cancel-btn').on('click', function () {
        buttonsResetAndUnbindSortable();

        datatable.ajax.reload(function() {
            fixDatatableBug();
            // sakrij kolonu sa 'sorting hadle' elementima
            datatable.column(0).visible(false);

            // za 'editableTableWidget()'
            $('#entities-table tbody tr').find('td.editable').attr('tabindex', 1);
        });
    });

    // Posalji preko ajaksa novi raspored 'priority'-ja kategorija.
    $('#priority-save-btn').on('click', function () {
        let priorityMap = $(".sortable-entities").sortable("toArray");

        // Nepoznato poreklo prvog "" elementa !!! TODO: naci kako/gde se on generise
        // Nastao je tek nakon integracije 'sortable' sa 'datatables'-om.
        console.log(priorityMap);
        if(priorityMap.length && priorityMap[0] === "") {
            priorityMap.shift();
        }

        let ajaxData = {
            "priority_map": priorityMap,
            "map_collection_range": "full"
        };

        $.ajax({
            'url': blade.prioritySaveAjaxUrl,
            'type': 'POST',
            'data': ajaxData, 
            // ne poziva se .done() zato sto ajax.blade.php $.ajaxSetup ima 'success' i 'error' 'callback' funkcije.
            'success': function(response) { 
                buttonsResetAndUnbindSortable();

                // za 'editableTableWidget()'
                $('#entities-table tbody tr').find('td.editable').attr('tabindex', 1);
            }
        });            

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="delete"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="enable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="disable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });


});
</script>
@endpush