@push('head_links')
<link href="{{asset('/theme/plugins/select2/css/select2.min.css')}}" rel="stylesheet" type="text/css" />
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row justify-content-center">
        <div class="col-lg-7 align-self-center">
            @csrf
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Naziv')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('title', 'is-invalid')" 
                        name="title" 
                        placeholder="@lang('Naziv')" 
                        required
                        value="{{old('title', $entity->title)}}"
                        @if($entity->id)
                        readonly
                        @endif
                    >
                    @formError(['field' => 'title'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Kratki naziv')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('short_title', 'is-invalid')" 
                        name="short_title" 
                        placeholder="@lang('Kratki naziv')" 
                        required
                        value="{{old('short_title', $entity->short_title)}}"
                    >
                    @formError(['field' => 'short_title'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Web adresa')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="url" 
                        class="form-control @errorClass('url', 'is-invalid')" 
                        name="url" 
                        placeholder="@lang('Web adresa')" 
                        required
                        value="{{old('url', $entity->url)}}"
                    >
                    @formError(['field' => 'url'])
                    
                </div>
            </div>
        </div>
        <!-- UPLOAD FAJLOVA -->
        <div class="col-lg-4 offset-lg-1">
            @include('websites.partials.form.image_logo')   
            @include('websites.partials.form.image_icon')
        </div>
        <!-- KRAJ UPLOAD FAJLOVA -->
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
@endpush