<?php

Route::get('/', 'BackofficeUsersBaseController@index')->name('index');

Route::middleware('can:backoffice_users:users')->name('users.')->prefix('/users')->group(function() {
    
    Route::get('/', 'UsersController@index')->name('index');
    Route::post('/datatable', 'UsersController@datatable')->name('datatable');
    Route::get('/create', 'UsersController@create')->name('create');
    Route::post('/create', 'UsersController@store');
    Route::get('/{entity}/edit', 'UsersController@edit')->name('edit');
    Route::post('/{entity}/edit', 'UsersController@update');
    Route::post('/{entity}/delete', 'UsersController@delete')->name('delete');
});

Route::middleware('can:backoffice_users:groups')->name('groups.')->prefix('/groups')->group(function() {
    
    Route::get('/', 'GroupsController@index')->name('index');
    Route::post('/datatable', 'GroupsController@datatable')->name('datatable');
    Route::get('/create', 'GroupsController@create')->name('create');
    Route::post('/create', 'GroupsController@store');
    Route::get('/{entity}/edit', 'GroupsController@edit')->name('edit');
    Route::post('/{entity}/edit', 'GroupsController@update');
    Route::post('/{entity}/delete', 'GroupsController@delete')->name('delete');
});