<?php $__env->startPush('head_links'); ?>
    <link href="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')); ?>" rel="stylesheet" />
    <style>
        .newscms-edit-title {
            position: absolute; top: 0%;
        }
        .newscms-edit-submit {
            position: absolute; bottom: 5%;
        }
    </style>
<?php $__env->stopPush(); ?>

<form action="<?php echo e(route('profile.edit')); ?>" method="post" id="edit_profila_form" class="contact-form" enctype="multipart/form-data" autocomplete="off">
    <?php echo csrf_field(); ?>

    <div class="row newscms-edit-title">
        <div class="col-12">
            <div class="h4">
                Izmena profilnih podataka
            </div>
        </div> 
    </div>

    <div class="row">

        <div class="col-12">
            <div class="form-group">
                <label for="fname"><?php echo e(__('Ime')); ?></label>
                <input class="form-control <?= $errors->has("first_name") ? 'is-invalid' : ""; ?>" 
                        id="fname" 
                        name="first_name" 
                        placeholder="<?php echo e(__('Ime')); ?>" 
                        type="text" 
                        value="<?php echo e(old('first_name', auth()->user()->first_name)); ?>" 
                        required
                        >
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'first_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="form-group">
                <label for="lname"><?php echo e(__('Prezime')); ?></label>
                <input class="form-control <?= $errors->has("last_name") ? 'is-invalid' : ""; ?>" 
                        id="lname" 
                        name="last_name" 
                        placeholder="<?php echo e(__('Prezime')); ?>" 
                        type="text" 
                        value="<?php echo e(old('last_name', auth()->user()->last_name)); ?>"
                        required
                        >
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'last_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="form-group">
                <label for="phone"><?php echo e(__('Telefon')); ?></label>
                <input class="form-control <?= $errors->has("phone") ? 'is-invalid' : ""; ?>" 
                        id="phone" 
                        name="phone" 
                        placeholder="<?php echo e(__('Telefon')); ?>" 
                        type="text" 
                        value="<?php echo e(old('phone', auth()->user()->phone)); ?>"
                        required
                        >
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'phone'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="form-group">
                <label for="email"><?php echo e(__('Imejl')); ?></label>
                <input class="form-control <?= $errors->has("email") ? 'is-invalid' : ""; ?>" 
                        id="email" 
                        name="email" 
                        type="email" 
                        placeholder="<?php echo e(__('Imejl')); ?>" 
                        value="<?php echo e(old('email', auth()->user()->email)); ?>" 
                        required
                        >
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'email'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

        </div> 

        <div class="col-1">
        </div>

        <div class="col-6">
            
        </div>
    </div>
    
    <div class="row newscms-edit-submit">
        <div class="col-12">
            <div class=""> 
                <button type="submit" class="btn btn-success" id="send"><?php echo app('translator')->get('Izmeni podatke'); ?></button>
            </div>
        </div> 
    </div>

</form>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')); ?>"></script>
<script>
$(function() {

    var blade = {
        "edit_password_url": "<?php echo e(route('profile.edit_password')); ?>"
    }

    // FRONTEND VALIDACIJA
    $('#edit_profila_form').validate({
        rules: {
            first_name:{
               required: true
            },
            last_name:{
               required: true
            },
            phone:{
            },
            email: {
                required: true,
                email: true
            }
        }
    });

    /* Izmena lozinke <button> click event */
    $('#edit_lozinku_btn').on('click', function() {
        window.location = blade.edit_password_url;
    });  

});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/profile/partials/form.blade.php ENDPATH**/ ?>