<?php $__env->startPush('head_links'); ?>
<link href="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            <?php echo csrf_field(); ?>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Ime firme'); ?></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("name") ? 'is-invalid' : ""; ?>" 
                        name="name" 
                        placeholder="<?php echo app('translator')->get('Ime firme'); ?>" 
                        value="<?php echo e(old('name', $entity->name)); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Adresa'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("address") ? 'is-invalid' : ""; ?>" 
                        name="address" 
                        placeholder="<?php echo app('translator')->get('Adresa'); ?>" 
                        value="<?php echo e(old('address', $entity->address)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-home"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'address'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('JIB'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("jib") ? 'is-invalid' : ""; ?>" 
                        name="jib" 
                        placeholder="<?php echo app('translator')->get('JIB'); ?>" 
                        value="<?php echo e(old('jib', $entity->jib)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-id-card-o"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'jib'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('PDV'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("pdv") ? 'is-invalid' : ""; ?>" 
                        name="pdv" 
                        placeholder="<?php echo app('translator')->get('PDV'); ?>" 
                        value="<?php echo e(old('pdv', $entity->pdv)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-id-card-o"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'pdv'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Email'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("email") ? 'is-invalid' : ""; ?>" 
                        name="email" 
                        placeholder="<?php echo app('translator')->get('Email'); ?>" 
                        value="<?php echo e(old('email', $entity->email)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-at"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'email'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Telefon'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("phone") ? 'is-invalid' : ""; ?>" 
                        name="phone" 
                        placeholder="<?php echo app('translator')->get('Telefon'); ?>" 
                        value="<?php echo e(old('phone', $entity->phone)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-phone"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'phone'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Valuta'); ?></label>
                <div class="col-sm-9 input-group">
                    <select 
                        class="form-control <?= $errors->has("currency") ? 'is-invalid' : ""; ?>" 
                        name="currency"
                    >
                        <option value="KM" <?php echo e(old('currency', $entity->currency) == 1 ? 'selected' : ''); ?>>KM</option>
                        <option value="EUR" <?php echo e(old('currency', $entity->currency) == 2 ? 'selected' : ''); ?>>EUR</option>
                    </select>
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-money"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'currency'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            
            
        </div>
        <div class="col-4 offset-1">
            
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')); ?>"></script>
<script>
$(function() {
    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            name: {
                required: true
            },
            address: {
                required: true
            },
            currency: {
                required: true
            },
            jib: {
                required: true,
                maxlength: 20
            },
            phone: {
                required: true,
                maxlength: 20
            },
            email: {
                required: true,
                email: true
            },
        },
        messages: {
            
        },
    });
});

});
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/truck/companies/partials/form.blade.php ENDPATH**/ ?>