<?php
    $id = $id ?? ( 'tag_id_' . rand(1000, 9999) );
    $name = $name ?? $id;
    $showSystemMessageOnCreate = $showSystemMessageOnCreate ?? false;
    $enableCreate = $enableCreate ?? true;
    $datatables = $datatables ?? null;
    
    // if exist collection of 'the most used tags' display after select
    $mostUsedTags = $mostUsedTags ?? [];
    $mostUsedTags = App\Http\Resources\Select2\Tag::collection($mostUsedTags);
    
    
    // if exist 'entity' select his tags
    if(isset($entity)){
        $value = $entity->tags->pluck('id')->toArray();
    } else {
        $value = [];
    }
    
    $tagsId = old($name, $value);
    $tags = App\Models\Tag::whereIn('id', $tagsId)->get();
    $tags = App\Http\Resources\Select2\Tag::collection($tags);
    
?>

<div class="mb-2">
    <select class="select2 form-control select2-hidden-accessible"
            multiple="multiple"
            data-placeholder="<?php echo app('translator')->get('-- Izaberi tag --'); ?>"
            name="<?php echo e($name); ?>[]"
            id="<?php echo e($id); ?>"
    >
    </select>
</div>
<?php if(isset($mostUsedTags) && count($mostUsedTags) > 0): ?>
<label class="control-label"><?php echo app('translator')->get('Najviše korišteni tagovi'); ?></label>
    <div class="d-flex flex-wrap">
        <?php $__currentLoopData = $mostUsedTags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div 
                class="btn btn-sm btn-secondary waves-effect waves-light empty-form most-used-tags mr-1 mb-1"
                data-id="<?php echo e($tag->id); ?>"
            >
                        <?php echo e($tag->title); ?>

            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php endif; ?>

<?php $__env->startPush('footer_scripts'); ?>
<script>
    let value = <?php echo json_encode($tags); ?>;
    let mostUsedTags = <?php echo json_encode($mostUsedTags); ?>;
    
    $('[name="<?php echo e($name); ?>[]"]').tagsSelect({
        sourceUrl: '<?php echo e($tagSelectUrl); ?>',
        storeUrl: '<?php echo e($tagStoreUrl); ?>',
        showSystemMessageOnCreate: '<?php echo e($showSystemMessageOnCreate); ?>',
        enableCreate: '<?php echo e($enableCreate); ?>',
        newTagLabel: " (<?php echo app('translator')->get('Dodaj novi tag'); ?>)",
        datatables: '<?php echo e($datatables); ?>',
        value: value,
        mostUsedTags: mostUsedTags
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/_layout/partials/form/tags_select.blade.php ENDPATH**/ ?>