<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <?php echo csrf_field(); ?>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Naziv Kategorije'); ?><sup>*</sup></label>
        <div class="col-sm-9">
            <input 
                type="text" 
                class="form-control <?= $errors->has("name") ? 'is-invalid' : ""; ?>" 
                name="name" 
                placeholder="<?php echo app('translator')->get('Naziv'); ?>" 
                value="<?php echo e(old('name', $entity->name)); ?>"
            >
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Boja'); ?><sup>*</sup></label>
        <div class="col-sm-5">
            <div id="colorpicker-element" data-color-format="hex" data-color="#305AA2" class="colorpicker-default input-group">
                <input type="text" readonly="readonly" value="#305AA2" class="form-control" name="color">
                <span class="input-group-append add-on">
                    <button class="btn btn-white" type="button">
                        <i style="background-color: #305AA2; margin-top: 2px;"></i>
                    </button>
                </span>
            </div>
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'color'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Slika'); ?></label>
        <div id="image_input_wrapper" class="col-sm-9 d-none">
            <input 
                type="file" 
                class="form-control <?= $errors->has("logo") ? 'is-invalid' : ""; ?>" 
                name="logo" 
                placeholder="<?php echo app('translator')->get('Slika'); ?>"
            >
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'logo'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Prikaz Slike'); ?></label>
        <div class="col-sm-9" id="show_image_wrapper">
            <img src="<?php echo e($entity->getImgSrcPath('logo')); ?>" title="#" class="img-fluid <?php if(!$entity->logo): ?> d-none <?php endif; ?>"/>
        </div>
    </div>
    <fieldset class="mt-4">
        <legend class="h4 p-3 mt-5 bg-light"><?php echo app('translator')->get('SEO Optimizacija'); ?></legend>
        <div class="form-group row">
            <label class="col-sm-3 control-label"><?php echo app('translator')->get('Seo Naslov'); ?><sup>*</sup></label>
            <div class="col-sm-9">
                <input 
                    type="text" 
                    class="form-control <?= $errors->has("seo_title") ? 'is-invalid' : ""; ?>" 
                    name="seo_title" 
                    placeholder="<?php echo app('translator')->get('Seo Naslov'); ?>" 
                    value="<?php echo e(old('seo_title', $entity->seo_title)); ?>"
                >
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'seo_title'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-3 control-label"><?php echo app('translator')->get('Seo Opis'); ?><sup>*</sup></label>
            <div class="col-sm-9">
                <textarea 
                    class="form-control <?= $errors->has("seo_description") ? 'is-invalid' : ""; ?>" 
                    name="seo_description" 
                    placeholder="<?php echo app('translator')->get('Seo Opis'); ?>" 
                    spellcheck="false"
                ><?php echo e(old('seo_description', $entity->seo_description)); ?></textarea>
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'seo_description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-sm-3 control-label"><?php echo app('translator')->get('Seo Ključne Reči'); ?><sup>*</sup></label>
            <div class="col-sm-9">
                <input 
                    type="text" 
                    class="form-control <?= $errors->has("seo_keywords") ? 'is-invalid' : ""; ?>" 
                    name="seo_keywords" 
                    placeholder="<?php echo app('translator')->get('Seo Ključne Reči'); ?>" 
                    value="<?php echo e(old('seo_keywords', $entity->seo_keywords)); ?>"
                >
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'seo_keywords'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </fieldset>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>

<?php $__env->startPush('head_links'); ?>
<link href="/theme/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css" rel="stylesheet">
<link href="/packages/fileinput/fileinput.css" rel="stylesheet">
<style>
    .fileinput-wrapper {
        display: table;
    }
    .fileinput.form-control {
        background-color: #e9ecef;
        color: '#dee2e6';
        width: 163px;
    }
    .fileinput.form-control:hover {
        background-color: #d9dcdf;
    }
    .fileinput.form-control > span{
        padding-left: 18px;
    }
    .fileinput-name {
        display: table-cell !important;
        vertical-align: middle;
        word-break: break-all;
        padding-bottom: 8px;
        padding-left: 10px;
    }

    .colorpicker-element > span {
        border: 1px solid #dadada;
        border-top-right-radius: 4px;
        border-bottom-right-radius: 4px;
    }
    .colorpicker-element button {
        background-color: #e9ecef;
    }
    .colorpicker-element button:hover {
        background-color: #d9dcdf;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script src="/theme/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<script src="/packages/fileinput/fileinput.min.js"></script>
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.15.0/additional-methods.js"></script>
<script>
$(function () {

    var blade = {
        color: "<?php echo e(old('color', $entity->color ?? $defaultHexColor)); ?>",
        jqValidateErrTrans: "<?php echo app('translator')->get('Fajl slike nema validnu ekstenziju.'); ?>"
    };

    // FRONTEND VALIDACIJA
    $.extend( $.validator.messages, {
        extension: blade.jqValidateErrTrans
    });
    $('#entity-form').validate({
        rules: {
            name:{
               required: true,
               minlength: 3
            },
            color:{
                required: true
            },
            seo_title: {
                required: true,
                minlength: 3
            },
            seo_description: {
                required: true,
                minlength: 3
            },
            seo_keywords: {
                required: true,
                minlength: 3
            },
            logo: {
                extension: 'jpeg|jpg|png|bmp'
            }
        }
    });

    // COLORPICKER
    $('#colorpicker-element').colorpicker({
        color: blade.color,
        format: 'hex',
    });

    $('input[type="file"]').fileinput({
        title: "<?php echo app('translator')->get('Izaberite sliku...'); ?>",
        clearButton: '',
        buttonClass: 'btn btn-default',
        complete: function(e) {
            // sprecava 'blink' originalnog 'file' elementa.
            $("#image_input_wrapper").removeClass('d-none');
        }
    });

    // IMAGE PREVIEW
    if(window.FileReader) {
        $('input[type="file"]').on('change', function(e) {
            let files = e.target.files;
            let f = files[0];
            let reader = new FileReader();
            
            reader.onload = (function(inputFile) {
                    return function(e) {
                        $("#show_image_wrapper > img").attr('src', e.target.result)
                                                      .attr('title', inputFile.name)
                                                      .removeClass('d-none');
                    };
            })(f);
            
            reader.readAsDataURL(f);
        });
    }
    else {
        //TODO: posalji sliku na server preko ajaksa pozovi njen 'src' u 'img' elementu
        console.log('Pretrazivac ne podrzava "FileReader" API.');
    }

});
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/categories/partials/form.blade.php ENDPATH**/ ?>