<?php $__env->startSection('head_title', __('Vozila') . ' - ' . __('Vozila')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Vozila"),
    'breadcrumbs' => [
        route('truck.trucks') => __('Vozila')
    ]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Lista Vozila'); ?></h3>
                </div>
                <div class="card-heading-actions">
                    <a href="<?php echo e(route('truck.trucks_create')); ?>" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        <?php echo app('translator')->get('Dodaj'); ?>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table">
                        <thead>
                            <tr>
                                <th class=""><?php echo app('translator')->get(''); ?></th>
                                <th class=""><?php echo app('translator')->get('Proizvodjač'); ?></th>
                                <th class=""><?php echo app('translator')->get('Naziv Vozila'); ?></th>
                                <th class=""><?php echo app('translator')->get('Broj saobraćajne'); ?></th>
                                <th class=""><?php echo app('translator')->get('Tablice'); ?></th>
                                <th class="disabled-sorting text-right"><?php echo app('translator')->get('Opcije'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl:"<?= route('truck.trucks_datatable'); ?>"
    };
    
    // DATATABLES
    $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "image", orderable: false, searchable: false, "className": ""},
            {"data": "producer", "className": ""},
            {"data": "name", "className": ""},
            {"data": "traffic_number", "className": ""},
            {"data": "number_of_plates", "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]]
    });
    
    
    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/truck/trucks/index.blade.php ENDPATH**/ ?>