
<?php if(!empty($entity->filename) && 
    preg_match('/^(?P<creation_date>\d{4}-\d{2}-\d{2})\/(?P<id>\d*)_(?P<fname>.*?)\.(?P<ext>.{3,4})$/', $entity->filename, $matches)): ?>
<div class="datatable-image-wrapper" 
        data-photo-id="<?php echo e($entity->id); ?>" 
        data-photo-thumb-size-id="<?php echo e($thumbSize); ?>" 
        data-photo-thumb-params="<?php echo e(json_encode($entity->thumb_params)); ?>"
        data-photo-width="<?php echo e($entity->width); ?>"
        data-photo-height="<?php echo e($entity->height); ?>"
        data-photo-source="<?php echo e($entity->source); ?>"
        data-photo-signature="<?php echo e($entity->alt); ?>"
        data-photo-filename="<?php echo e(basename($entity->filename)); ?>"
        data-photo-category-id="<?php echo e($entity->category); ?>"
        data-photo-licence-id="<?php echo e($entity->licence_id); ?>"
        data-photo-licence-name="<?php echo e($entity->licence_name); ?>"
        data-photo-created-at="<?php echo e($entity->getDatetimeColumnFormatted('created_at')); ?>"
        data-photo-updated-at="<?php echo e($entity->getDatetimeColumnFormatted('updated_at')); ?>"
        data-photo-creation-date="<?php echo e($entity->creation_date); ?>"
        data-photo-creation-user-id="<?php echo e($entity->creation_user); ?>"
        data-photo-mod-user-id="<?php echo e($entity->mod_user); ?>"
        data-photo-pristine-img-src="<?php echo e($entity->getImgSrcPath() . $timestamp); ?>" 
        data-photo-source-img-src="<?php echo e($entity->getSourceImgSrcPath($thumbSize) . $timestamp); ?>" 
        data-photo-img-src="<?php echo e($entity->getImgSrcPath($thumbSize) . $timestamp); ?>" 
        data-photo-img-src-template="<?php echo e($entity->getImgSrcTemplate()); ?>"
        data-photo-template-placeholder="<?php echo e($entity::DEFAULT_TEMPLATE_PLACEHOLDER); ?>"
        data-photo-tags-ids="<?php echo e($entity->tags->pluck('id')); ?>"
        data-photo-all-img-sources="<?php echo e($entity->getAllThumbsImgSrcs('JSON', TRUE)); ?>" 
    >
    <img 
        src="<?php echo e($entity->getImgSrcPath($thumbSize) . $timestamp); ?>" 
        alt=""
        data-photo-action="show" 
    >
    <div class="gallery-img-buttons">
        <a  href="<?php echo e($entity->getImgSrcPath($thumbSize)); ?>" 
            class="gallery-img-btn" 
            title="Download"
            download 
            >
            <i class="fa fa-download"></i></a>
        <a  href="javascript:;" 
            class="gallery-img-btn" 
            title="<?php echo app('translator')->get('Izmeni'); ?>"
            data-photo-action="edit" 
            >
            <i class="fa fa-pencil"></i></a>
        <a  href="javascript:;" 
            class="gallery-img-btn" 
            title="<?php echo app('translator')->get('Izbriši'); ?>"
            data-photo-action="delete" 
            data-title="<?php echo app('translator')->get('Izbriši'); ?>"
            data-id="<?php echo e($entity->id); ?>"
            data-text="<?php echo app('translator')->get('Da li ste sigurni da želite da obrišete sliku #~b~#'); ?>"
            data-label="<?php echo e($entity->filename); ?>"
            data-ajax-url="<?php echo e(route('media.library.delete', $entity->id)); ?>"
            >
            <i class="fa fa-trash"></i></a>
    </div>
</div>
<?php endif; ?>

<?php /**PATH /opt/cms/resources/views/_layout/partials/modal/media_library/partials/table/image.blade.php ENDPATH**/ ?>