<!-- DATE SELECTORS -->
<div class="row">
    <div class="col-lg-5">
        <div class="form-group">
            <label class="control-label"><?php echo app('translator')->get('Datum unosa'); ?><sup>*</sup></label>
            <div class="">
                <input
                        type="text"
                        class="form-control"
                        name="time_created"
                        placeholder="<?php echo app('translator')->get('Datum'); ?>"
                        id="date"
                        value="<?php echo e(old('time_created', optional($entity->time_created)->format('Y-m-d H:i'))); ?>"
                        data-mask="9999-99-99 99:99"
                        data-name="articleTimeCreated"
                >
            </div>
        </div>
    </div>
    <div class="col-lg-2">
        <div class="form-group">
            <label class="control-label text-white"><?php echo app('translator')->get('sad'); ?></label>
            <div>
                <button class="btn btn-secondary waves-effect waves-light set-date-now">
                    <i class="fa fa-clock-o"></i>
                </button>
            </div>
        </div>
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('articles-approve')): ?>
    <div class="col-lg-5">
        <div class="form-group">
            <div class="d-flex align-items-center">
                <input type="hidden" name="published" value="0">
                <input type="checkbox"
                       class="mb-2 mr-2 approve-approval-time"
                       name="published"
                       id="published"
                       value="1"
                       <?php if(old('published', $entity->published) == 1): ?>
                       checked
                       <?php endif; ?>
                       >
                <label class="control-label" for="published"><?php echo app('translator')->get('Odobri u'); ?></label>
            </div>
            <div class="">
                <input
                        type="text"
                        class="form-control"
                        name="publish_at"
                        placeholder="<?php echo app('translator')->get('Datum'); ?>"
                        value="<?php echo e(old('publish_at', $entity->published ? optional($entity->publish_at)->format('Y-m-d H:i') : '')); ?>"
                        data-mask="9999-99-99 99:99"
                        data-name="articleHasPubishTimer"
                        disabled
                >
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<hr>
<!-- CATEGORY SELECTORS -->
<div class="row">

    <div class="col-lg-3">
        <div class="form-group">
            <label class="control-label"><?php echo app('translator')->get('Kategorija'); ?></label>
            <div class="">
                <?php
                    $selectedMainCat = collect(json_decode($mainCategories, true))->filter(function($value, $key) use ($entity){
                                          return $value['id'] == old('category_id', $entity->category_id);;
                                        })->first();
                ?>
                <select name="category_id" class="form-control select-category" data-website-id="0">
                    <?php if(!empty($selectedMainCat) && count($selectedMainCat)): ?>
                        <option value="<?php echo e($selectedMainCat['id']); ?>"><?php echo e($selectedMainCat['text']); ?></option>
                    <?php endif; ?>
                </select>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="form-group">
            <label class="control-label"><?php echo app('translator')->get('Podkategorija'); ?></label>
            <div class="subcategory_select">
                <?php
                    $selectedMainSubCat = collect(json_decode($mainSubCategories, true))->filter(function($value, $key) use ($entity){
                                          return $value['id'] == old('subcategory_id', $entity->subcategory_id);;
                                        })->first();
                ?>
                <select name="subcategory_id" class="form-control select-subcategory" data-website-id="0">
                    <?php if(!empty($selectedMainSubCat) && count($selectedMainSubCat)): ?>
                        <option value="<?php echo e($selectedMainSubCat['id']); ?>"><?php echo e($selectedMainSubCat['text']); ?></option>
                    <?php endif; ?>
                </select>
            </div>
        </div>
    </div>
</div>
<hr>
<!-- TAGS SELECTORS -->
<div class="row">
    <div class="col-12">
        <?php echo $__env->make('_layout.partials.form.tags_select', [
                'id' => 'tags_id',
                'name' => 'tags',
                'tagSelectUrl' => @route('tags.select_tag'),
                'tagStoreUrl' => @route('tags.create_tag'),
                'datatables' => 'entities-table',
                'entity' => $entity,
                'mostUsedTags' => $mostUsedTags
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>
<hr>
<!-- FLAG SELECTORS -->

<div class="row">
    <div class="col-lg-2">
        <div class="d-flex align-items-center">
            <input type="hidden" class="mb-2 mr-2" name="comments" value="0">
            <input type="checkbox" class="mb-2 mr-2" name="comments" id='article-comments'
                   value="1" <?php echo e(old('comments', $entity->comments) == 1 ? "checked" : ""); ?>>
            <label class="control-label" for="article-comments"><?php echo app('translator')->get('Komentari'); ?></label>
        </div>
    </div>
    <div class="col-lg-2">
        <div class="d-flex align-items-center">
            <input type="hidden" class="mb-2 mr-2" name="show_banners" value="0">
            <input type="checkbox" class="mb-2 mr-2" name="show_banners" id='article-banners'
                   value="1" <?php echo e(old('show_banners',  $entity->show_banners) == 1 ? "checked" : ""); ?>>
            <label class="control-label" for="article-banners"><?php echo app('translator')->get('Prikaži banere'); ?></label>
        </div>
    </div>
    <div class="col-lg-2">
        <div class="d-flex align-items-center">
            <input type="hidden" class="mb-2 mr-2" name="free_article" value="0">
            <input type="checkbox" class="mb-2 mr-2" name="free_article" id='article-free-news'
                   value="1" <?php echo e(old('free_article',  $entity->free_article) == 1 ? "checked" : ""); ?>>
            <label class="control-label" for="article-free-news"><?php echo app('translator')->get('Besplatna vest'); ?></label>
        </div>
    </div>
    <div class="col-lg-2">
        <div class="d-flex align-items-center">
            <input type="hidden" class="mb-2 mr-2" name="more_soon" value="0">
            <input type="checkbox" class="mb-2 mr-2" name="more_soon" id="article-more-soon"
                   value="1" <?php echo e(old('more_soon', $entity->more_soon) == 1 ? "checked" : ""); ?>>
            <label class="control-label" for="article-more-soon">"<?php echo app('translator')->get('Uskoro opširnije'); ?>"</label>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="d-flex align-items-center">
            <input type="hidden" class="mb-2 mr-2" name="ban_in_latest_news" value="0">
            <input type="checkbox" class="mb-2 mr-2" name="ban_in_latest_news" id='ban_in_latest_news'
                   value="1" <?php echo e(old('ban_in_latest_news',  $entity->ban_in_latest_news) == 1 ? "checked" : ""); ?>>
            <label class="control-label" for="ban_in_latest_news"><?php echo app('translator')->get('Ne prikazuj u najnovijim vestima'); ?></label>
        </div>
    </div>
    
    <div class="col-lg-2">
        <div class="d-flex align-items-center">
            <input type="hidden" class="mb-2 mr-2" name="live" value="0">
            <input type="checkbox" class="mb-2 mr-2" name="live" id='article-live'
                   value="1" <?php echo e(old('live', $entity->live) == 1 ? "checked" : ""); ?>>
            <label class="control-label" for="article-live"><?php echo app('translator')->get('Uživo'); ?></label>
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-lg-6">
        <label class="control-label" for="article-comments">Tip vesti (Publication reason)</label>
        <div class="d-flex align-items-center">
            <div class="radio">
                <label>
                    <input type="radio" name="publication_reason" value="editorial" <?php echo e(old('publication_reason', $entity->publication_reason) == "editorial" ? "checked" : ""); ?> checked>
                    <span class="cr"><i class="cr-icon mdi mdi-checkbox-blank-circle"></i></span>
                        Obicna vest (editorial)
                </label>
                <br>
                <label>
                    <input type="radio" name="publication_reason" value="sponsored" <?php echo e(old('publication_reason', $entity->publication_reason) == "sponsored" ? "checked" : ""); ?>>
                    <span class="cr"><i class="cr-icon mdi mdi-checkbox-blank-circle"></i></span>
                        Sponzorisana vest (sponsored)
                </label>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <label class="control-label" for="article-comments">Trajanje vesti (lifetime)</label>
        <div class="d-flex align-items-center">
            <div class="radio">
                <label>
                    <input type="radio" name="lifetime" value="time limited" <?php echo e(old('lifetime', $entity->lifetime) == "time limited" ? "checked" : ""); ?> checked>
                    <span class="cr"><i class="cr-icon mdi mdi-checkbox-blank-circle"></i></span>
                        Dnevna vest
                </label>
                <br>
                <label>
                    <input type="radio" name="lifetime" value="evergreen" <?php echo e(old('lifetime', $entity->lifetime) == "evergreen" ? "checked" : ""); ?> >
                    <span class="cr"><i class="cr-icon mdi mdi-checkbox-blank-circle"></i></span>
                        Evergreen (jednom napisane, uvek aktuelne teme)
                </label>
                <br>
                <label>
                    <input type="radio" name="lifetime" value="seasonal" <?php echo e(old('lifetime', $entity->lifetime) == "seasonal" ? "checked" : ""); ?>>
                    <span class="cr"><i class="cr-icon mdi mdi-checkbox-blank-circle"></i></span>
                        Sezonska vest(izbori, svetska prvenstva, praznici)
                </label>
                <br>
                
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('footer_scripts'); ?>
    <script src="/theme/plugins/bootstrap-inputmask/bootstrap-inputmask.min.js"></script>
    <script>
        $(document).ready(function () {
            function generateNowDateTime()
            {
                var currentTime = new Date();
                var day = currentTime.getDate(),
                    month = currentTime.getMonth() + 1,
                    year = currentTime.getFullYear(),
                    hour = currentTime.getHours(),
                    minute = currentTime.getMinutes();
                month = month < 10 ? '0' + month : month;
                day = day < 10 ? '0' + day : day;
                hour = hour < 10 ? '0' + hour : hour;
                minute = minute < 10 ? '0' + minute : minute;

                var dateTime =  [year, month, day].join('-') + ' ' + [hour, minute].join(':');

                return dateTime;
            }
            $('button.set-date-now').on('click', function (e) {

                e.preventDefault();
                e.stopPropagation();

                $('[data-name="articleTimeCreated"]').val(
                    generateNowDateTime()
                );

            });

            if( $('input.approve-approval-time').is(':checked')){
                $('[data-name="articleHasPubishTimer"]').removeAttr('disabled');
            }

            $('input.approve-approval-time').on('change', function (e) {
                var articlePublishTimeElement = $('[data-name="articleHasPubishTimer"]');
                if ($('input.approve-approval-time').prop('checked')) {
                    articlePublishTimeElement.removeAttr('disabled');
                    if (!articlePublishTimeElement.val()) {
                        let articleTime = $('[data-name="articleTimeCreated"]').val();
                        if (articleTime === '') {
                           
                            articleTime = generateNowDateTime();
                        }
                        articlePublishTimeElement.val(articleTime);
                    }
                    ;
                } else {
                    articlePublishTimeElement.attr('disabled', 'disabled');
                    articlePublishTimeElement.val('');
                }

            });
            //otklanjanje greske iz bootstra-inputmask plugin-a
            jQuery.browser = {};
        });

    </script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/articles/partials/form/selectors.blade.php ENDPATH**/ ?>