<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResource;
use App\Services\LockResourceService;

class SessionController extends Controller
{

    /**
     * 'Ajax endpoint' koji samo odrzava sesiju aktivnom
     */
    public function ajaxMaintainSession(Request $request) 
    {
        return JsonResource::make()->withSuccess('');
    }

    /*
     * 'Ajax endpoint' koji 'refresh'-uje 'lock' resursa
     */
    public function ajaxMaintainResourceLock(Request $request, LockResourceService $lockService)
    {

        $data = $request->validate([
            'resource_id' => ['required', 'integer'],
            'resource_name' => ['required', 'string']
        ]);

        // osvezi 'lock' resursa
        $stat = $lockService->updateLock($data['resource_id'], $data['resource_name']);

        if($stat) {
            return JsonResource::make()->withSuccess('');
        }
        return JsonResource::make()->withError('Greska! Auto-zakljucavanje resursa je neuspesno.');
    }
}
