<?php

namespace App\Http\Controllers;

//change the request class if needed
use Illuminate\Http\Request as Request;

use App\Models\Truck\Truck as Entity;
use App\Models\Website\Website;

use Junges\ACL\Models\Group;

use App\Http\Resources\Select2\Role;
use Illuminate\Validation\Rule;

use App\Http\Resources\JsonResource;
use Illuminate\Support\Carbon;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class TruckTrucksController extends Controller 
{
    protected $request;
    
    public function __construct(Request $request)
    {
        $this->request = $request;

    }
    
    public function index()
    {   
        return view('truck.trucks.index');
    }
    
    /*
     * Yajrabox datatables metod
     */
    public function datatable()
    {
        $query = Entity::query()->where('id', '>', 0)->orderBy('created_at', 'desc');

        return datatables($query)
            ->addColumn('actions', function ($entity) {
                return view('truck.trucks.partials.table.actions', 
                            ['entity' => $entity]);
            })
            ->addColumn('image', function ($entity) {
                return view('truck.trucks.partials.table.image', 
                            ['entity' => $entity]);
            })
            
            ->editColumn('phone', function ($entity) {
                return $entity-> phone ? $entity->phone : '---';
            
            })->editColumn('registracija_end', function($entity){
                if ($entity->registracija_end) {
                    $date = Carbon::parse($entity->registracija_end);
                    return $date->format('d-m-Y');
                }
                return "---------";
            })->editColumn('sestomjesecni_end', function($entity){
                if ($entity->sestomjesecni_end) {
                    $date = Carbon::parse($entity->sestomjesecni_end);
                    return $date->format('d-m-Y');
                }
                return "---------";
            })->editColumn('pp_end', function($entity){
                if ($entity->pp_end) {
                    $date = Carbon::parse($entity->pp_end);
                    return $date->format('d-m-Y');
                }
                return "---------";
            })->editColumn('tahograf_end', function($entity){
                if ($entity->tahograf_end) {
                    $date = Carbon::parse($entity->tahograf_end);
                    return $date->format('d-m-Y');
                }
                return "---------";
            })
           
            ->rawColumns(['actions', 'image'])
            ->setRowAttr([
                'data-id' => function($entity) {
                    return $entity->id;
                }
            ])
            ->make(true);
    }
    
    public function create()
    {   
        $entity = new Entity();
        
        return view('truck.trucks.create', [
            'entity' => $entity,
        ]);
    }
    
    public function store()
    {   
        $request = $this->request;
        
        $data = $request->validate([
            'producer' => ['required', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:100'],
            'traffic_number' => ['required', 'string', 'max:20'],
            'number_of_plates' => ['required', 'string', 'max:10'],
            'registracija_start' => ['required', 'date_format:d-m-Y'],
            'registracija_end' => ['required', 'date_format:d-m-Y'],
            'sestomjesecni_start' => ['required', 'date_format:d-m-Y'],
            'sestomjesecni_end' => ['required', 'date_format:d-m-Y'],
            'pp_start' => 'required|date_format:d-m-Y',
            'pp_end' => 'required|date_format:d-m-Y',
            'tahograf_start' => ['nullable', 'date_format:d-m-Y'],
            'tahograf_end' => ['nullable', 'date_format:d-m-Y'],
        ]);

        // Convert date fields to Y-m-d format using Carbon if they have values
        if (!empty($data['registracija_start'])) {
            $data['registracija_start'] = Carbon::createFromFormat('d-m-Y', $data['registracija_start'])->format('Y-m-d');
        }

        if (!empty($data['registracija_end'])) {
            $data['registracija_end'] = Carbon::createFromFormat('d-m-Y', $data['registracija_end'])->format('Y-m-d');
        }

        if (!empty($data['sestomjesecni_start'])) {
            $data['sestomjesecni_start'] = Carbon::createFromFormat('d-m-Y', $data['sestomjesecni_start'])->format('Y-m-d');
        }

        if (!empty($data['sestomjesecni_end'])) {
            $data['sestomjesecni_end'] = Carbon::createFromFormat('d-m-Y', $data['sestomjesecni_end'])->format('Y-m-d');
        }

        if (!empty($data['pp_start'])) {
            $data['pp_start'] = Carbon::createFromFormat('d-m-Y', $data['pp_start'])->format('Y-m-d');
        }

        if (!empty($data['pp_end'])) {
            $data['pp_end'] = Carbon::createFromFormat('d-m-Y', $data['pp_end'])->format('Y-m-d');
        }

        if (!empty($data['tahograf_start'])) {
            $data['tahograf_start'] = Carbon::createFromFormat('d-m-Y', $data['tahograf_start'])->format('Y-m-d');
        }

        if (!empty($data['tahograf_end'])) {
            $data['tahograf_end'] = Carbon::createFromFormat('d-m-Y', $data['tahograf_end'])->format('Y-m-d');
        }


        $entity = new Entity();
        $entity->fill($data);
        $entity->save();
        
        
        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Vozač je uspešno sačuvan!'));
        }
        
        return redirect()->route('truck.trucks')->withSystemSuccess(__('Vozač je uspešno sačuvan!'));
    }
    
    public function edit(Entity $entity)
    {
            return view('truck.trucks.edit', [
            'entity' => $entity,
        ]);
    }
    
    public function update(Entity $entity)
    {
        $request = $this->request;

        $data = $request->validate([
            'producer' => ['required', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:100'],
            'traffic_number' => ['required', 'string', 'max:20'],
            'number_of_plates' => ['required', 'string', 'max:10'],
            'registracija_start' => ['required', 'date_format:d-m-Y'],
            'registracija_end' => ['required', 'date_format:d-m-Y'],
            'sestomjesecni_start' => ['required', 'date_format:d-m-Y'],
            'sestomjesecni_end' => ['required', 'date_format:d-m-Y'],
            'pp_start' => 'required|date_format:d-m-Y',
            'pp_end' => 'required|date_format:d-m-Y',
            'tahograf_start' => ['nullable', 'date_format:d-m-Y'],
            'tahograf_end' => ['nullable', 'date_format:d-m-Y'],
        ]);

        // Convert date fields to Y-m-d format using Carbon if they have values
        if (!empty($data['registracija_start'])) {
            $data['registracija_start'] = Carbon::createFromFormat('d-m-Y', $data['registracija_start'])->format('Y-m-d');
        }

        if (!empty($data['registracija_end'])) {
            $data['registracija_end'] = Carbon::createFromFormat('d-m-Y', $data['registracija_end'])->format('Y-m-d');
        }

        if (!empty($data['sestomjesecni_start'])) {
            $data['sestomjesecni_start'] = Carbon::createFromFormat('d-m-Y', $data['sestomjesecni_start'])->format('Y-m-d');
        }

        if (!empty($data['sestomjesecni_end'])) {
            $data['sestomjesecni_end'] = Carbon::createFromFormat('d-m-Y', $data['sestomjesecni_end'])->format('Y-m-d');
        }

        if (!empty($data['pp_start'])) {
            $data['pp_start'] = Carbon::createFromFormat('d-m-Y', $data['pp_start'])->format('Y-m-d');
        }

        if (!empty($data['pp_end'])) {
            $data['pp_end'] = Carbon::createFromFormat('d-m-Y', $data['pp_end'])->format('Y-m-d');
        }

        if (!empty($data['tahograf_start'])) {
            $data['tahograf_start'] = Carbon::createFromFormat('d-m-Y', $data['tahograf_start'])->format('Y-m-d');
        }

        if (!empty($data['tahograf_end'])) {
            $data['tahograf_end'] = Carbon::createFromFormat('d-m-Y', $data['tahograf_end'])->format('Y-m-d');
        }


        $entity->fill($data);
        $entity->save();
        
        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Vozač je uspešno izmenjen!'));
        }
        
        return redirect()->route('truck.trucks')->withSystemSuccess(__('Vozač je uspešno izmenjen!'));
    }
    
    public function delete(Entity $entity)
    {
        $entity->delete();
        
        if ($this->request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Vozač je uspešno obrisan!'));
        }
        
        return redirect()->route('truck.trucks.index')->withSystemSuccess(__('Vozač je uspešno obrisan!'));
    }

}
