<?php

namespace App\Http\Resources\Select2;

use Illuminate\Http\Resources\Json\ResourceCollection;

class PermissionGroup extends ResourceCollection
{
    public function toArray($request)
    {
        self::wrap('results');
        $returnArray = [];
        foreach($this as $key => $item){
            $returnArray[$key]['id'] = $item->guard_name;
            $returnArray[$key]['text'] = $item->name;
            $returnArray[$key]['children'] = collect([[
                    'id' => $item->id,
                    'text' => $item->name,
                ]]);
        }
        return $returnArray;

    }
}
