<?php

namespace App\Listeners;

use App\Events\ArticleLog;
use App\Models\ArticleMetaData;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;

class SaveArticleMetaData
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  ArticleLog  $event
     * @return void
     */
    public function handle(ArticleLog $event)
    {
        $article = $event->article;
        $data = $event->data;
        
        $articleMetaData = ArticleMetaData::where('article_id', $article->id)->first();

        $update = false;
        if($articleMetaData && isset($articleMetaData->log)){
            $log = json_decode($articleMetaData->log, true);
        }
        
        $message = 'Updated: ';
        foreach($data as $key=>$element){
            if(isset($article->{$key}) || is_null($article->{$key})){
                if(!in_array($key, ['time_created', 'publish', 'time_updated_real', 'time_created_date', 'updated_by', 'time_changed'])){
                    
                    if($key == 'tags'){
                        $entityTags = $article->tags->pluck('id')->toArray();
                        if(count(array_diff($entityTags, $data['tags'])) > 0 || count($entityTags) != count($data['tags'])){
                            $message.='tags, ';
                            $update = true;
                        }
                    }else if($key == 'articleRelated'){
                        if($element !=  $article->related){
                            $message.='related, ';
                            $update = true;
                        }
                    }
                    else if($key == 'publish_at'){
                        if($element.':00' !=  $article->publish_at){
                            $message.='publish_at, ';
                            $update = true;
                        }
                    }
                    else if($article->{$key} != $element){
                        $message.=$key.', ';
                        $update = true;
                    }
                }
            }
        }

        if($update){
            $log[] = [
                'updatedBy' => auth()->user()->id,
                'updatedAt' => now()->format('Y-m-d H:i:s'),
                'message' => $message
            ];
            if(!$articleMetaData){
                $articleMetaData = new ArticleMetaData();
                $articleMetaData->article_id = $article->id;
            }
            $articleMetaData->log = json_encode($log);
            $articleMetaData->save();
        }

    }
}
