<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ImportedUserEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($contactName, $contactEmail, $content)
    {
        $this->contactName = $contactName;
        $this->contactEmail = $contactEmail;
        $this->content = $content;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $this->from(env('MAIL_FROM_ADDRESS', ''), config('website.after_job_email_name'))
             ->replyTo(config('website.after_job_email'))
             ->subject('Dobrodošli na novi NIN sajt!');
        return $this->view('emails.imported_user_email')->with([
            'contactName' => $this->contactName,
            'content'     => $this->content
        ]);
    }

   
}
