<?php

namespace App\Models\Website;

use Illuminate\Database\Eloquent\Model;
use App\Models\Utils\ActiveInactive;
use App\Models\Utils\ActiveInactiveModel;
use Illuminate\Database\Eloquent\SoftDeletes;

use App\Models\Robno\Lager;

class Website extends Model implements ActiveInactive
{
    use SoftDeletes;
    use ActiveInactiveModel;
    use \App\Models\Utils\ImageableTrait;
    use \App\Models\Utils\CrudObserverTrait;

    const COMMON_WEBSITE_ID = 0;
    
    protected $table = "websites";
    
    protected $fillable = ['title', 'short_title', 'url', 'status', 'photo'];
    
    protected $imageResizeRecepies = [
        "slika_logo" => [
            [
                "type" => "resize",
                "w" => 500
            ],
            [
                "type" => "fit",
                /*"w" => 384, // Dimenzija za 'top-left' logo u aplikaciji
                "h" => 128*/
                "w" => 192,
                "h" => 120
            ]
        ], 
        "slika_icon" => "icon64"
    ];

    protected $with = ['images'];
    
    /*
     * Vrati 'public URL' do 'logo' slike - ukoliko website ima 
     * 'logo' sliku.
     */
    public function getLogoImg()
    {
        $logoImg = $this->getImage('slika_logo');
        return !empty($logoImg) ? $logoImg->getUrl() : config('newscms.default_logo_img_src');
    }
    
    /*
     * Vrati 'public URL' do 'icon' slike - ukoliko website ima 
     * 'icon' sliku.
     */
    public function getIconImg()
    {
        $iconImg = $this->getImage('slika_icon');
        return !empty($iconImg) ? $iconImg->getUrl() : config('newscms.default_icon_img_src');
    }
    
    /** 
     * Vrati listu svih ID-jeva website-ova kao znakovni niz. 
     * 
     * @return string
     */
    public static function getAllIdsStr()
    { 
        $strVal = '';

        $websites = self::all()->pluck('id')->toArray();
        
        if(count($websites) > 0) {
            $strVal = implode(',', $websites);
        }
        return $strVal;
    }
}
