<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('truck_invoices', function (Blueprint $table) {
            $table->id();
            $table->string('id_invoice', 10)->nullable()->unique();
            $table->text('text')->nullable();
            $table->integer('company')->nullable();
            $table->integer('status')->default(0);
            $table->integer('driver')->nullable();
            $table->integer('truck')->nullable();
            $table->decimal('price', 8, 2)->nullable()->default(0.00);
            $table->decimal('price_part', 8, 2)->nullable()->default(0.00);
            $table->decimal('debt', 8, 2)->nullable()->default(0.00);
            $table->string('currency', 10)->nullable();
            $table->date('date_start')->nullable(false);
            $table->date('date_end')->nullable(false);
            $table->date('date_done')->nullable();
            $table->timestamps();
            $table->softDeletes(); 
            $table->unsignedBigInteger("created_by")->nullable();
            $table->unsignedBigInteger("updated_by")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('truck_invoices');
    }
};

