<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Junges\ACL\Models\Group;
use Junges\ACL\Models\Permission;
use App\Models\User;

class BasicPermissionsSeeder extends Seeder
{
    
    protected $permissions = [
        'websites',
        'profile',
        'priorities',
        'polls',
        'banners',
        'branding',
        'articles',
        'categories',
        'authors',
        'tags',
        'groups',
        'users',
        'settings',
        'media-categories',
        'media-library',
        'comments',
        'push',
        'ads-txt',
        'printed-editions',
        'pages',
        'reports',
        'media-sources',
        'articles-approve',
        'articles-delete',
        'videos',
    ];

    protected $otherGroups = [
        'urednik',
        'novinar',
        'advertising'
    ];




    /**
     * Runs the DB seed
     */
    public function run()
    {
        //kreiramo grupu admin i preuzimamo id grupe
        $adminGroup = Group::create([
            'name' => 'admin'
        ]);

        //popunjavamo tabelu sa permisijama i dodajemo sve permisije adminu
        $permissionIds = [];
        foreach($this->permissions as $permission){
            $newPermission = Permission::create([
                'name' => $permission,
                'description' => 'Omogucava rad sa '.$permission
            ]);

            $adminGroup->assignPermission($newPermission);
        }

        //ubacujemo ostale default-ne grupe
        foreach($this->otherGroups as $group){
            Group::create([
                'name' => $group
            ]);
        }

        $user = User::where('id',0)->first()->assignGroup($adminGroup);

    }
}
