<!-- CONTENT CKEDITOR -->
<div class="form-group">
    <textarea id="contentEditor" name="text" class="form-control" rows="5">{{old('text', $entity->text)}}</textarea>
</div>
@push('head_links')
    <link href="{{asset('/custom/ckeditor/contents.css')}}" rel="stylesheet" type="text/css"/>
@endpush
@push('footer_scripts')
    <script src="{{asset('/custom/ckeditor/ckeditor.js')}}"></script>
    <script src="{{asset('/custom/ckeditor/adapters/jquery.js')}}"></script>
    <script type="text/javascript">
        $(document).ready(function(){

        $('#contentEditor').ckeditor({
            height: '200px',
            bodyId: 'article_content',
            bodyClass: 'news-content single-news single-news-content',
            extraPlugins: 'pastetext,news,socialembed',
            toolbar: [
                {name: 'document', groups: ['mode', 'doctools'], items: ['Source', '-', 'Templates']},
                {
                    name: 'clipboard',
                    groups: ['clipboard', 'undo', 'cleanup'],
                    items: ['Cut', 'Copy', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo', '-', 'RemoveFormat']
                },
                {name: 'basicstyles', groups: ['basicstyles'], items: ['Bold', 'Italic', 'Underline', 'Strike']},
                {
                    name: 'paragraph',
                    groups: ['list', 'indent', 'align'],
                    items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']
                },
                {name: 'links', items: ['Link', 'Unlink']},
                {name: 'styles', items: ['Format']},
                {name: 'colors', items: ['TextColor', 'BGColor']},
                {name: 'tools', items: ['ShowBlocks', 'Maximize']},
                {name: 'insert', items: ['Image']}

            ],
            forcePasteAsPlainText: true,
            allowedContent: true,
            contentsCss: [
                '/custom/ckeditor/skins/moono/editor.css',
                '/custom/ckeditor/single-news.css',
                '/custom/ckeditor/single-news-custom.css',
            ]
        });
        
    });
    </script>
@endpush