@extends('_layout.layout')

@section('head_title', __('Novi Website') . ' - ' . __('Admin'))

@push('head_links')
@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Novi Website"),
    'breadcrumbs' => [
        route('websites.index') => __('Websites'),
    ]
])

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Kreiranje novog Website-a')</h3>
                    <p class="card-sub-title text-muted">@lang('Polja sa * su obavezna')</p>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('websites.index')}}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i>
                        @lang('Nazad')
                    </a>
                </div>
            </div>
            <div class="card-body">
                @include('websites.partials.form', ['entity' => $entity])
            </div>
        </div>
    </div>
</div>

@endsection
