@extends('_layout.layout')

@section('head_title', __('Websites') . ' - ' . __('Admin'))

@push('head_links')
@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Websites"),
    'breadcrumbs' => [
        route('websites.index') => __('Websites')
    ]
])

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Websites list')</h3>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('websites.create')}}" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        @lang('Dodaj')
                    </a>
                </div>
            </div>
            <div class="card-body">
                <table class="table table-striped" id="entity-list-table">
                    <thead>
                        <tr>
                            <th class="text-center">@lang('Status')</th>
                            <th class="text-center">@lang('Ikonica')</th>
                            <th class="text-center">@lang('Naziv')</th>
                            <th>@lang('Kratki naziv')</th>
                            <th>@lang('Web adresa')</th>
                            <th class="text-center">@lang('Opcije')</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>

@endsection

@push('footer_scripts')
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl:"@route('websites.datatable')"
    };
    
    
    // DATATABLES
    $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "active", searchable: false, "className": "text-center"},
            {"data": "icon", orderable: false, searchable: false, "className": "text-center"},
            {"data": "title", "className": "text-center"},
            {"data": "short_title"},
            {"data": "url"},
            {"data": "actions", orderable: false, searchable: false, "className": "text-center"}
        ],
        "order": [[0, "asc"]]
    });
    
    // DELETE MODAL
    $('#entity-list-table').questionPop({
        "liveSelector": '[data-action="delete"]'
    }).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

    // ENABLE MODAL
    $('#entity-list-table').questionPop({
        "liveSelector": '[data-action="enable"]'
    }).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

    // DISABLE MODAL
    $('#entity-list-table').questionPop({
        "liveSelector": '[data-action="disable"]'
    }).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

});
</script>
@endpush