<?php $__env->startPush('head_links'); ?>
<link href="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<style>
    #currency {
        text-align: center;
    }
    .form-group input[readonly] {
        background-color: white; /* Opcionalno: stilizacija readonly inputa */
    }
</style>

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-12 align-self-center">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="control-label"><?php echo app('translator')->get('Broj fakture'); ?></label>
                        <input 
                            type="text" 
                            class="form-control <?= $errors->has("id_invoice") ? 'is-invalid' : ""; ?> enterable" 
                            name="id_invoice" 
                            placeholder="<?php echo app('translator')->get('Broj Fakture'); ?>" 
                            value="<?php echo e(old('id_invoice', $entity->id_invoice)); ?>"
                        >
                        <?php echo $__env->make('_layout.partials.form.error', ['field' => 'id_invoice'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="col-lg-2">
                    <div class="form-group">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="control-label"><?php echo app('translator')->get('Firma'); ?></label>
                        <select id="companySelect" name="company" class="form-control <?= $errors->has("company") ? 'is-invalid' : ""; ?> enterable">
                            <option value="0" disabled selected><?php echo app('translator')->get('Izaberi'); ?></option>
                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($company->id); ?>" data-currency="<?php echo e($company->currency); ?>" <?php if(old('company', $entity->company) == $company->id): ?> selected <?php endif; ?>><?php echo e($company->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php echo $__env->make('_layout.partials.form.error', ['field' => 'company'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

            <hr>
            <?php
                if($entity->date_start){
                    $dateStart = date('d-m-Y', strtotime($entity->date_start));
                    $dateEnd = date('d-m-Y', strtotime($entity->date_end));
                }else{
                    $dateStart = '';
                    $dateEnd = '';
                }
            ?>
            <div class="row">
                <?php if(old('date_start', $dateStart)): ?>
                <div class="col-lg-6">
                    <div class="form-group row">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Datum početka'); ?></label>
                        <div class="col-sm-5">
                            <input
                                type="text"
                                class="form-control <?= $errors->has("date_start") ? 'is-invalid' : ""; ?> enterable"
                                placeholder="<?php echo app('translator')->get('Datum'); ?>"
                                value="<?php echo e(old('date_start', $dateStart)); ?>"
                                readonly
                            >
                            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'date_start'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <input type="hidden" name="date_start" value="<?php echo e(old('date_start', $dateStart)); ?>">
                    </div>
                </div>
                <?php else: ?>
                <div class="col-lg-6">
                    <div class="form-group row">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Datum početka'); ?></label>
                        <div class="col-sm-5">
                            <input
                                type="text"
                                class="form-control <?= $errors->has("date_start") ? 'is-invalid' : ""; ?> enterable"
                                name="date_start"
                                id="date_start"
                                placeholder="<?php echo app('translator')->get('Datum'); ?>"
                                value="<?php echo e(old('date_start', $dateStart)); ?>"
                            >
                            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'date_start'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="col-lg-6">
                    <div class="form-group row">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Rok placanja'); ?></label>
                        <div class="col-sm-5">
                            <input
                                type="text"
                                class="form-control <?= $errors->has("date_end") ? 'is-invalid' : ""; ?> enterable"
                                name="date_end"
                                id="date_end"
                                placeholder="<?php echo app('translator')->get('Datum'); ?>"
                                value="<?php echo e(old('date_end', $dateEnd)); ?>"
                            >
                            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'date_end'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
                  
            <hr>
            
            <div class="row">
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Vozac'); ?></label>
                        <select name="drivers[]" class="form-control <?= $errors->has("drivers") ? 'is-invalid' : ""; ?> enterable" multiple>
                            <option value="" disabled><?php echo app('translator')->get('Izaberi'); ?></option>
                            <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($driver->id); ?>" <?php if(in_array($driver->id, old('drivers', $entity->drivers->pluck('id')->toArray()))): ?> selected <?php endif; ?>>
                                    <?php echo e($driver->first_name); ?> <?php echo e($driver->last_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php echo $__env->make('_layout.partials.form.error', ['field' => 'drivers'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="col-lg-2">
                    <div class="form-group">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Vozilo'); ?></label>
                        <select name="trucks[]" class="form-control select2 <?= $errors->has("trucks") ? 'is-invalid' : ""; ?> enterable" multiple>
                            <option value="" disabled><?php echo app('translator')->get('Izaberi'); ?></option>
                            <?php $__currentLoopData = $trucks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $truck): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($truck->id); ?>" <?php if(in_array($truck->id, old('trucks', $entity->trucks->pluck('id')->toArray()))): ?> selected <?php endif; ?>>
                                    <?php echo e($truck->producer); ?> | <?php echo e($truck->number_of_plates); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php echo $__env->make('_layout.partials.form.error', ['field' => 'trucks'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

            <hr>

            <div class="row">
                <div class="col-lg-6">
                    <div class="form-group">
                        <label for="text" class="col-sm-3 control-label"><?php echo app('translator')->get('Napomena'); ?></label>
                        <textarea id="text" name="text" placeholder="<?php echo app('translator')->get('Napomena'); ?>" class="form-control <?= $errors->has("text") ? 'is-invalid' : ""; ?> enterable"><?php echo e(old('text', $entity->text)); ?></textarea>
                        <?php echo $__env->make('_layout.partials.form.error', ['field' => 'text'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="form-group col-lg-4">
                    <div class="row">
                        <div class="col-lg-9">
                                <label class="control-label"><?php echo app('translator')->get('Ukupan iznos za uplatu'); ?></label>
                                <div class="input-group">
                                    <input 
                                        type="text" 
                                        class="form-control <?= $errors->has("price") ? 'is-invalid' : ""; ?> enterable" 
                                        name="price" 
                                        placeholder="<?php echo app('translator')->get('0.00'); ?>" 
                                        value="<?php echo e(old('price', $entity->price)); ?>"
                                    >
                                </div>
                                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'price'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>  
                        <div class="col-lg-3">
                            <div id="currencyDisplay" class="form-group">
                                <label class="control-label invisible"><?php echo app('translator')->get('Valuta'); ?></label> <!-- Nevidljiva labela za poravnanje -->
                                <input 
                                    id="currency"
                                    type="text" 
                                    class="form-control <?= $errors->has("price") ? 'is-invalid' : ""; ?> enterable" 
                                    name="currency" 
                                    placeholder="<?php echo app('translator')->get('Valuta'); ?>" 
                                    value="<?php echo e(old('currency', $entity->currency)); ?>"
                                    readonly
                                >
                            </div>
                        </div>  
                    </div>
                </div>
            </div>
        </div>
        <div class="col-4 offset-1">
            
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')); ?>"></script>

<script>
    // Funkcija koja se poziva kada se izabere nova opcija
   
</script>

<script>
$(function() {
    
    $(document).ready(function() {

    $('#companySelect').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var currency = selectedOption.data('currency');

        // Ažuriramo data-currency atribut
        $('#currencyDisplay .input-group-text').text(currency);

        // Ažuriramo skriveno polje
        $('#currency').val(currency);
    });

    $.validator.addMethod("validDate", function(value, element) {
        return moment(value,"DD-MM-YYYY", true).isValid();
    }, "<?php echo e(__('Unesite validan format DD-MM-GGGG.')); ?>");
    $.validator.addMethod("greaterStart", function (value, element, params) {
        //Konvertujemo datume i vracamo error alp je dateStart manji od dateEnd
        var dateStart= $('#entity-form [name="date_start"]').val().split("-")
        dateStart = new Date(dateStart[2], dateStart[1] - 1, dateStart[0]);
        var dateEnd= $('#entity-form [name="date_end"]').val().split("-")
        dateEnd = new Date(dateEnd[2], dateEnd[1] - 1, dateEnd[0]);
        return this.optional(element) || dateStart <= dateEnd;
    },"<?php echo e(__('Mora biti veće od datuma početka.')); ?>");

    $('#entity-form').validate({
        rules: {
            id_invoice: {
                required: true
            },
            company: {
                required: true,
            },
            date_start: {
                required: true,
                validDate: true
            },
            date_end: {
                required: true,
                validDate: true,
                greaterStart: '[name="date_start"]'
            },
            driver: {
                required: true,
            },
            truck: {
                required: true,
            },
            price:{
                required: true
            },
        },
        messages: {
            
        }
    });

    $('select').select2({
        minimumResultsForSearch: -1
    });

    $('#date_start').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    $('#date_end').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    // $('#entity-form [name="date_start"]').on('change', function(e){
    //     e.preventDefault();
    //     let start = $('#entity-form [name="date_start"]').val();
    //     let split = start.split('-');
    //     let end10 = parseInt(split[2]) + 10;

    //     $('#entity-form [name="date_end"]').val(split[0] + '-' + split[1] + '-' + end10);

    // });
});

});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/truck/invoices/partials/form.blade.php ENDPATH**/ ?>