<?php
$categories->shift()
?>


<?php $__env->startSection('head_title', __('Uredništvo') . ' - ' . __('Prioriteti')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Prioriteti"),
    'websitePicker' => 1,
    'routeName' => 'priorities.index'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php if($activeWebsite || $activeWebsite === '0'): ?>
<form id="articles-priority-form" style="display:none" action="<?php echo e(route('priorities.save_priority_articles')); ?>" method="post">
    <?php echo csrf_field(); ?>
    
</form>
<div class="row">
    <div class="col-lg-7">
        <div class="card">
            <div class="card-heading d-flex flex-wrap justify-content-between align-items-center pb-0">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Prioriteti'); ?></h3>
                </div>
                <div class="card-heading-actions form-group mb-0 row align-items-center justify-content-end">
                    <label class="col-sm-4 text-right control-label mb-0"><?php echo app('translator')->get('Ubaci Vest'); ?></label>
                    <div class="col-sm-3 pl-sm-0">
                        <input class="form-control input-sm quick-priority-insert" placeholder="ID" value="">
                    </div>
                </div>
            </div>
            <hr>
            <div class="card-body pt-1">
                <div class="form-group row">
                    <div class="col-6">
                        <label class="control-label" style=""><?php echo app('translator')->get('Tip prioriteta'); ?></label>
                            <select name="priorities" class="form-control priority-set-selector priority-select">
                                <?php $__currentLoopData = $priorities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $priority): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($priority->type); ?>" data-priority-group="<?php echo e($priority->group); ?>"><?php echo e($priority->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                    </div>
                    <div id="select-priority-categories" class="col-3" style="display:none;">
                        <label class="control-label" style=""><?php echo app('translator')->get('Kategorija'); ?></label>
                            <select name="categories" class="form-control priority-set-selector category-select">
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-category-name="<?php echo e($category->name); ?>" value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                    </div>
                    <div id="select-priority-subcategory" class="col-3" style="display:none;">
                    <label class="control-label" style=""><?php echo app('translator')->get('Podkategorija'); ?></label>
                        <select name="subcategories" class="form-control priority-set-selector subcategory-select">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <optgroup label="<?php echo e($category->name); ?>">
                                <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($subcategory->id); ?>"><?php echo e($subcategory->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        
                    </div>
                </div>
                <hr>
                <div class="articles-priorities-wrapper">
                </div>
            </div>
            <div class="pl-4 mb-3">
                <button class="btn btn-sm btn-warning waves-effect waves-light" id="submit-button">
                    <i class="fa fa-check-circle"></i>
                    <?php echo app('translator')->get('Sačuvaj'); ?>
                </button>
            </div>
            
        </div>
    </div>
    <div class="col-lg-5">
        <?php echo $__env->make('priorities.partials.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('head_links'); ?>
<link href="<?php echo e(asset('/theme/plugins/jquery-ui/jquery-ui.min.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/jquery-ui/jquery-ui.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('/theme/plugins/jquery-ui-touch-punch/jquery.ui.touch-punch.min.js')); ?>" type="text/javascript"></script>
    <script> 
    $(document).ready(function(){

        // premesteno iz priorities partials list.blade da bi se koristila funkcija getPriorityArticles
        // cime se refresh-uje forma prioriteta pri brisanju artikla iz datatable
        $('#entities-table').questionPop({
        "liveSelector": '[data-action="delete"]'
        }).on('success.qp', function() {
            $('#entities-table').DataTable().draw('page');
            getPriorityArticles();

        });
        var priorities = JSON.parse('<?php echo json_encode($priorities->toArray()); ?>');

        //GET SELECTED PRIORITY PROPERTY
        function getSelectedPriorityProperty(property = 'limit'){
            let prioritySet = getPrioritySet();
            let selectedPriorityType = priorities.filter(function (i,n){      
                return i.type == prioritySet.priority_type;
            })[0];
                return selectedPriorityType[property];
        }

        //GET ONE ARTICLE
        function getArticle(articleId){
            let activeWebsite = "<?php echo e($activeWebsite); ?>";
            let prioritySet = getPrioritySet();

            $.ajax({
                    "url": "<?php echo e(route('priorities.get_one_article')); ?>",
                    "type": "post",
                    "data": {
                        "article_id": articleId,
                        "activeWebsite": activeWebsite,
                        "priorityType": prioritySet.priority_type
                    }
                }).done(function(response){
                    // let responseArticle = response.data.priorityArticle.publish;
                    let responseArticle = response.data.priorityArticle;
                    let mainCategoryId = response.data.priorityArticle.category_id;
                    let mainSubcategoryId = response.data.priorityArticle.subcategory_id;
                    let prioritySet = getPrioritySet();
                    let status = true;
                    let messageType = 'error';
                    
                    // let responseArticlePublish = responseArticle.filter(function (i,n){   
                    //         if(prioritySet.site_id == 0){
                    //             return true;
                    //         }   
                    //         return i.site_id == prioritySet.site_id;
                    //     })[0];
                    
                    if(response.data.exists){
                        status = false;
                        message = "<?php echo app('translator')->get('Vest se već nalazi u prioritetu " + response.data.priorityTitle + " i mozete je dodati u novi prioritet tek kada je obrisete iz postojeceg!'); ?>";
                    }

                    // if(responseArticle.length > 0){
                        if(getSelectedPriorityProperty() < getExistingPriorityArticlesIds().length + 1){
                            status = false;
                            message = "<?php echo app('translator')->get('Maksimalni broj vesti je ispunjen!'); ?>";
                            
                        }
                        
                        // if(!responseArticlePublish){
                            // status = false;
                            // message = "<?php echo app('translator')->get('Vest ne pripada izabranom sajtu!'); ?>";
                        // }else{
                            // if(prioritySet.site_id != responseArticlePublish.site_id && prioritySet.site_id != 0){
                            //     status = false;
                            //     message = "<?php echo app('translator')->get('Vest ne pripada izabranom sajtu!'); ?>";
                            // }
                            //IDEJA ZA PRIORITET TRAVEL/////////////////////////
                            // if(prioritySet.priority_type == 'zdravlje'){
                            //     if(responseArticle.category.name != 'Zdravlje'){
                            //         status = false;
                            //         message = "<?php echo app('translator')->get('Vest ne pripada izabranoj kategoriji!'); ?>";  
                            //     }
                            // }
                            //////////////////////////////////////////////////
                            if(prioritySet.priority_type == 'category'){
                                
                                if(prioritySet.site_id == 0){
                                    
                                    if(!(prioritySet.priority_type_id == mainCategoryId)){
                                    status = false;
                                    message = "<?php echo app('translator')->get('Vest ne pripada izabranoj kategoriji!'); ?>";
                                    } 
                                }else {
                                    // if(!(prioritySet.priority_type_id == responseArticlePublish.category_id)){
                                    // status = false;
                                    // message = "<?php echo app('translator')->get('Vest ne pripada izabranoj kategoriji!'); ?>";
                                    // } 
                                }
                                
                            }

                            if(prioritySet.priority_type == 'subcategory'){
                                if(prioritySet.site_id == 0){
                                    if(!(prioritySet.priority_type_id == mainSubcategoryId)){
                                    status = false;
                                    message = "<?php echo app('translator')->get('Vest ne pripada izabranoj podkategoriji!'); ?>";
                                    } 
                                }else {
                                    // if(!(prioritySet.priority_type_id == responseArticlePublish.subcategory_id)){
                                    // status = false;
                                    // message = "<?php echo app('translator')->get('Vest ne pripada izabranoj podkategoriji!'); ?>";
                                    // } 
                                }
                            }

                        // }

                        if(getExistingPriorityArticlesIds().includes(response.data.priorityArticle.id)){
                            status = false;
                            message = "<?php echo app('translator')->get('Vest je već na listi!'); ?>";
                        }
                    // }
                    
                    if(status){
                        $('.articles-priorities-wrapper').prepend(response.data.article_view); 
                        serializePriorityArticle();
                        message = "<?php echo app('translator')->get('Vest je uspešno dodata!'); ?>";
                        messageType = 'success';
                    }

                    showSystemMessage(message, messageType);
                    
                });
        }
        //GET PRIORITY SET
        function getPrioritySet(){

            let data = {
                'site_id': "<?php echo e($activeWebsite); ?>",
                'priority_type': $('.priority-set-selector.priority-select').val(),
                'priority_type_id': null
            };

            switch ($('.priority-set-selector.priority-select option:selected').data('priority-group')) {
                case "category":
                data.priority_type_id = $('.priority-set-selector.category-select').val();
                    break;
                case "subcategory":
                data.priority_type_id = $('.priority-set-selector.subcategory-select').val();
                    break;
            }

            return data;
        }

        //GET PRIORITY ARTICLES
        function getPriorityArticles(){

            $.ajax({
                "url": "<?php echo e(route('priorities.get_priority_articles')); ?>",
                "type": "post",
                "data": getPrioritySet()
            }).done(function(response){
                insertSerializedHtml(response);
            });
        }
        //GET LIST OF PRIORITY ARTICLES
        function getExistingPriorityArticlesList(){
            
            return $('.articles-priorities-wrapper .single-priority-article[data-article-id]');
            
        }
        //GET ARRAY OF PRIORITY ARTICLES IDS
        function getExistingPriorityArticlesIds(){
            let priorityArticles = getExistingPriorityArticlesList();

            let ids = [];

            $.each(priorityArticles, function(key, item){
                ids.push($(this).data('article-id'));
            });

            return ids;
        }
        //SERIALIZE DATA  ON FORM
        function serializePriorityArticle(){
            let priorityArticlesWrapper = $('.articles-priorities-wrapper');

            let priorityArticles = getExistingPriorityArticlesList();
            let priorityForm = $('#articles-priority-form');
            let prioritySet = getPrioritySet();

            priorityForm.find('input[name="prior_articles[]"]').remove();

            for(let prop in prioritySet){
                    priorityForm.find(`input[name="${prop}"]`).remove();
                }
            if(priorityArticles.length > 0){

                $.each(priorityArticles, function(key, item){
                    priorityForm.append(`
                    <input type="hidden" name="prior_articles[]" value="${$(this).data('article-id')}">
                    `);
                    if(key + 1 > getSelectedPriorityProperty('visible')){
                        
                        $(this).addClass('bg-warning');
                    }else{
                        $(this).removeClass('bg-warning');
                    }
                });
                for(let prop in prioritySet){
                    priorityForm.append(`
                    <input type="hidden" name="${prop}" value="${prioritySet[prop] ? prioritySet[prop] : ''}">
                    `);
                }
                
            }else {
                priorityForm.append(`
                    <input type="hidden" name="prior_articles[]" value="0">
                    `);

                for(let prop in prioritySet){
                    priorityForm.append(`
                    <input type="hidden" name="${prop}" value="${prioritySet[prop] ? prioritySet[prop] : ''}">
                    `);
                }    
            }
        }
        //REMOVE HTML FOR ONE ARTICLE AND SERIALIZE DATA ON FORM
        function removeArtcleFromPriority(target){
            target.closest('div.single-priority-article').remove();
            serializePriorityArticle();
        }
        //GET ONE ARTICLE PRIORITY SET
        function getArticlePrioritySet(target){
            let data = {
                'article_id': target.data('id'),
                'site_id': getPrioritySet().site_id,
                'priority_type': getPrioritySet().priority_type,
                'priority_type_id': getPrioritySet().priority_type_id
            };

            return data;
        }
        //INSERT HTML RESPONSE AND SERIALIZE DATA ON FORM
        function insertSerializedHtml(response){
            $('.articles-priorities-wrapper').html(response.data.articles_view);
            serializePriorityArticle();
        }

        <?php if($activeWebsite || $activeWebsite === '0'): ?>
        getPriorityArticles();
        showSelectForCategories($('.priority-set-selector'));
        <?php endif; ?>

        $('[name="priorities"]').select2({
            
        });
        $('[name="categories"]').select2({
            
        });
        $('[name="subcategories"]').select2({
            
        });

        function showSelectForCategories(target){
            console.log(target.find('option:selected').data('priority-group'), target.find('option:selected').val());
            let prioritySelectStatus = target.hasClass('priority-select');
            if(prioritySelectStatus){
                let priorityGroup = target.find('option:selected').data('priority-group');
                let priorityType = target.find('option:selected').val();
                
                switch (priorityGroup) {
                    case "general":
                    $('.priority-set-selector').not(target).parent().hide();
                        break;
                    case "category":
                    $('.priority-set-selector.category-select').parent().show();
                    $('.priority-set-selector.subcategory-select').parent().hide();
                        break;
                    case "subcategory":
                    $('.priority-set-selector.category-select').parent().hide();
                    $('.priority-set-selector.subcategory-select').parent().show();
                        break;
                }
                //ideja za travel kategorijus
                //dodato sakrivanje kategorije selekta kada je group == category ali je type naziv kategorije travel
                // if(priorityType == 'zdravlje'){
                //     $('.priority-set-selector.category-select').parent().hide();
                //     $('option[data-category-name="Zdravlje"]').attr('selected', 'selected');
                // }
            }
        }

        //LISTENER ON CHANGE CATEGORIES AND SUBCATEGORIES
        $('.priority-set-selector').on('change', function(e){
            showSelectForCategories($(this));
            getPriorityArticles();
        });

        
        
        //SUBMIT FORM
        $('#submit-button').on('click', function(e){
            e.preventDefault();
            serializePriorityArticle();
            

            $.ajax({
                "url": "<?php echo e(route('priorities.save_priority_articles')); ?>",
                "type": "post",
                "data": $('#articles-priority-form').serialize()
            }).done(function(response){
                insertSerializedHtml(response);
            });
        });

        //QUICK INSERT ARTICLE TO PRIORITY LIST
        $('input.quick-priority-insert').on('keypress', function(e) {
            let code = e.keyCode || e.which;

            let articleId = $(this).val();

            if(code == 13){

                getArticle(articleId);
            }
        });
        //LISTENER FOR ADDING ARTICLE FROM DATABLE
        $('#entities-table').on('click', '.list-article-actions [data-action="add-prior-article"]', function(){

            let articleId = $(this).data('id');
            getArticle(articleId);      
        });
        //REMOVE ARTICLE FROM PRIORITY LIST
        $('.articles-priorities-wrapper').on('click', '.single-priority-article button[data-action="delete"]', function(){
            removeArtcleFromPriority($(this));
        });

        //SORTABLE
        $('.articles-priorities-wrapper').sortable({
            "handle": ".single-priority-handle",
            update: function(event, ui){
                serializePriorityArticle();
            }
            
        });
        //LISTENER ON REMOVE ARTICLE FROM ALL PRIORITIES
        $('.articles-priorities-wrapper').on('click', '.single-priority-article button[data-action="remove"]', function(e){
            
            let target = $(this);

            Swal.fire({
                title: target.data('title'),
                text: target.data('text'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonText: target.data('yes-text'),
                cancelButtonClass: 'btn btn-light',
                confirmButtonClass: 'btn btn-danger',
                cancelButtonText: target.data('no-text')
                
                
            }).then((result) => {
                
                if (result.value) { 
                    $.ajax({
                        'url': target.data('ajax-url'),
                        'type': 'post',
                        'data': getArticlePrioritySet(target)
                    })
                     .done((response) => {
                        var message = response['message'] ? response['message'] : 'OK';
                        insertSerializedHtml(response);    
                    });
                    
                }
    
            });
        });

    });
        
    
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/cms/resources/views/priorities/index.blade.php ENDPATH**/ ?>