<form action="" method="post" id="date_filter">
    <div class="row">
        <div class="col-lg-3">
            <div class="form-group row">
                <label class="col-sm-4 col-lg-4 control-label my-auto text-lg-right"><?php echo app('translator')->get('Datum od'); ?></label>
                <div class="col-sm-8 col-lg-8">
                    <input
                            type="text"
                            class="form-control <?= $errors->has("date_start") ? 'is-invalid' : ""; ?> datepicker"
                            name="date_start"
                            placeholder="<?php echo app('translator')->get('Datum'); ?>"
                            value="<?php echo e(old('date_start')); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'date_start'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="form-group row">
                <label class="col-sm-4 col-lg-4 control-label my-auto text-lg-right"><?php echo app('translator')->get('Datum do'); ?></label>
                <div class="col-sm-8 col-lg-8">
                    <input
                            type="text"
                            class="form-control <?= $errors->has("date_end") ? 'is-invalid' : ""; ?> datepicker"
                            name="date_end"
                            placeholder="<?php echo app('translator')->get('Datum'); ?>"
                            value="<?php echo e(old('date_end')); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'date_end'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="form-group row">
                <label class="control-label my-auto col-sm-4 col-lg-4 text-lg-right"><?php echo app('translator')->get('Admin korisnik'); ?></label>
                <div class="col-sm-8 col-lg-8">
                    <select name="company" class="form-control <?= $errors->has("company") ? 'is-invalid' : ""; ?>">
                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($company->id); ?>" <?php echo e(old('company') == $company->id ? "selected" : ""); ?>><?php echo e($company->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'company'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</form>


<?php $__env->startPush('footer_scripts'); ?>
    <script>

        function getResults(route) {
            let dateStart = $('#date_filter input[name="date_start"]').val();
            let dateEnd = $('#date_filter input[name="date_end"]').val();
            let company  = $('#date_filter select[name="company"]').val();

            $.ajax({
                "url": route,
                "method": "get",
                "data": {
                    "date_start": dateStart,
                    "date_end": dateEnd,
                    "company": company
                }
            }).done(function (response) {
                $('#tables').empty();
                $('#tables').append(response);
            });
        }

        $(function () {
            $('.datepicker').datepicker({
                "format": "dd.mm.yyyy",
                "autoclose": true
            });
            $('.datepicker').datepicker('setDate', 'now');

            $('[name="user"]').select2({});
        });


    </script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/truck/reports/partials/filter.blade.php ENDPATH**/ ?>