<div id="pollsModal" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Ankete'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                
            </div>
            <div class="d-flex justify-content-between mt-2 mb-1">
                <button type="button" class="btn btn-secondary" id="show-polls"><?php echo app('translator')->get('Selektuj staru anketu'); ?></button>
                <button type="button" class="btn btn-primary" id="show-form"><?php echo app('translator')->get('Kreiraj novu anketu'); ?></button>
            </div>
            <div id="select-polls" style="display:none">
                <label><?php echo app('translator')->get('Postojece Ankete'); ?></label>
                <select name="polls-intexts">
                </select>
            </div>
            <div class="modal-body pb-0 pt-1">
                <form id="polls-form" class="form-horizontal" method="post" action="" role="form"
                      enctype="multipart/form-data" autocomplete="off" style="display:none;">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" value="" name="entityId">
                    <hr>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group row">
                                <label class="col-sm-6 control-label"><?php echo app('translator')->get('Datum početka'); ?><sup>*</sup></label>
                                <div class="col-sm-6">
                                    <input
                                            type="text"
                                            class="form-control <?= $errors->has("date_from") ? 'is-invalid' : ""; ?>"
                                            name="date_from"
                                            placeholder="<?php echo app('translator')->get('Datum'); ?>"
                                            value="<?php echo e(old('date_from')); ?>"
                                            data-index="1"
                                    >
                                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'date_from'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group row">
                                <label class="col-sm-6 control-label"><?php echo app('translator')->get('Datum završetka'); ?><sup>*</sup></label>
                                <div class="col-sm-6">
                                    <input
                                            type="text"
                                            class="form-control <?= $errors->has("date_to") ? 'is-invalid' : ""; ?>"
                                            name="date_to"
                                            placeholder="<?php echo app('translator')->get('Datum'); ?>"
                                            value="<?php echo e(old('date_to')); ?>"
                                            data-index="2"
                                    >
                                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'date_to'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Pitanje'); ?><sup>*</sup></label>
                        <div class="col-sm-9">
                            <input
                                    type="text"
                                    class="form-control <?= $errors->has("question") ? 'is-invalid' : ""; ?>"
                                    name="question"
                                    placeholder="<?php echo app('translator')->get('Pitanje'); ?>"
                                    value="<?php echo e(old('question')); ?>"
                                    data-index="3"
                            >
                            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'question'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                    <?php
                        $answers = old('answers', ['']); // obezbedjuje jedan < div >
                        $votes = old('votes', ['']); // obezbedjuje jedan < div >
                        
                    ?>
                    <div class="form-group row answers-container">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Ponudjeni odgovori'); ?></label>
                        <div
                                id="poll-answers-container"
                                data-toggle="multi-items-control"
                                class="col-sm-12"
                                data-max-items="10"
                                data-min-items="1"
                        >
                            <?php $__currentLoopData = $answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="input-group mb-2" data-toggle="item-container" id="pollsAnswers">
                                    <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="fa fa-check-square-o"></i>
                    </span>
                                    </div>
                                    <input type="text"
                                           class="w-50 form-control <?php echo e($errors->has('answers.' .$i) ? 'is-invalid' : ''); ?>"
                                           name="answers[]"
                                           placeholder="<?php echo app('translator')->get('Unesite odgovor'); ?>"
                                           value="<?php echo e($answer); ?>"
                                           data-index="4">
                                    <input type="text"
                                           class="w-10 form-control <?php echo e($errors->has('votes.' .$i) ? 'is-invalid' : ''); ?>"
                                           name="votes[]"
                                           placeholder="<?php echo app('translator')->get('Glasova'); ?>"
                                           value="<?php echo e($votes[$i]); ?>"
                                           data-index="5">
                                    <div class="input-group-append">
                                        <button title="<?php echo app('translator')->get('Obrisi Ogovor'); ?>"
                                                class="btn btn-danger"
                                                type="button"
                                                data-action="remove-item"
                                                data-index="6">
                                            <i class="fa fa-minus"></i>
                                        </button>
                                        <button
                                                title="<?php echo app('translator')->get('Dodaj Odgovor'); ?>"
                                                class="btn btn-primary"
                                                type="button"
                                                data-action="add-item"
                                                data-index="6"
                                        >
                                            <i class="fa fa-plus"></i>
                                        </button>
                                    </div>
                                    <span class="d-none form-control <?php echo e($errors->has('answers.' .$i) ? 'is-invalid' : ''); ?>"></span>
                                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'answers.' . $i], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row justify-content-end">
                        <div class="col-sm-9 d-flex justify-content-end">
                            <button type="submit" class="btn btn-success mr-2 waves-effect waves-light"
                                    data-index="9">
                                <i class="fa fa-save"></i>
                                <?php echo app('translator')->get('Sačuvaj'); ?>
                            </button>
                            <button type="button" class="btn btn-secondary waves-effect waves-light"
                                    data-dismiss="modal">
                                <?php echo app('translator')->get('Odustani'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('head_links'); ?>
<style>
    .answers-container .text-danger{
        order: 1;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('footer_scripts'); ?>
    <script>
        function getPollsModal(){
            jQuery.validator.addMethod("greaterThan", function(value, element, params) {
                if (!/Invalid|NaN/.test(new Date(value))) {
                    return new Date(value) >= new Date($(params).val());
                }
                return isNaN(value) && isNaN($(params).val()) || (Number(value) > Number($(params).val())); 
            },"<?php echo app('translator')->get('Datum završetka ankete mora biti veći od datuma početka ankete.'); ?>");

            window['pollsModalInstance'] = window.hasOwnProperty('pollsModalInstance') ? window['pollsModalInstance'] : new ModalManagement({
                modal_selector: $('#pollsModal'),
                form_selector: $('#polls-form'),
                form_rules: {
                    "position": {
                        required: true
                    },
                    "date_from": {
                        required: true
                    },
                    "date_to": {
                        required: true,
                        greaterThan: '[name="date_from"]'
                    },
                    "question": {
                        required: true,
                        maxlength: 255
                    },
                    'answers[]': {
                        required: true
                    }
                },
                form_fill_on_ajax: false,
                ajax_getOne: "<?php echo e(route('articles.get_one_poll_intext')); ?>",
                ajax_getAll: '',
                ajax_create: "<?php echo e(route('articles.save_poll_intext')); ?>",
                ajax_update: "<?php echo e(route('articles.update_poll_intext')); ?>",
                ajax_delete: ''
            }).onCloseModal(function () {
                $('#pollsModal #polls-form input').val('');
                $('#polls-form').attr('style', 'display:none;');
                $('#select-polls').attr('style', 'display:none;');
                $('#pollsModal [name="old-poll"]').attr('data-id', '');
                $('#pollsModal select[name="polls-intexts"] option').remove();
                if ($('#polls-form input').hasClass('is-valid')) {
                    $('#polls-form input').removeClass('is-valid');
                }
                if ($('#polls-form input').hasClass('is-invalid')) {
                    $('#polls-form input').removeClass('is-invalid');
                    $('#polls-form input').next('div .text-danger').text("");
                }
                $('#poll-answers-container').html(
                    '<div class="input-group mb-2" data-toggle="item-container" id="pollsAnswers"><div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-check-square-o"></i> </span></div><input type="text" class="w-50 form-control" name="answers[]" placeholder="<?php echo app('translator')->get('Unesite odgovor'); ?>" value="' + value + '" data-index="4"><input type="text" class="w-10 form-control"name="votes[]" placeholder="<?php echo app('translator')->get('Glasova'); ?>" value="" data-index="5"><div class="input-group-append"><button title="<?php echo app('translator')->get('Obrisi Ogovor'); ?>" class="btn btn-danger" type="button" data-action="remove-item" data-index="6"><i class="fa fa-minus"></i></button><button title="<?php echo app('translator')->get('Dodaj Odgovor'); ?>" class="btn btn-primary" type="button" data-action="add-item" data-index="6"><i class="fa fa-plus"></i></button></div> <span class="d-none form-control"></span>'
                );
            }).onGetOneEntity(function (response) {
                let entity = JSON.parse(response);
                $('#pollsModal [name="polls-intexts"]').append(`
                <option value="${entity.id}" selected>${entity.question}</option>
                `);

                let answers = entity.answers.split('###');
                let votes = entity.votes.split('###');

                answers.pop();
                votes.pop();

                $.each(answers, function (index, value) {
                    if (index == 0) {
                        $('#poll-answers-container').html(
                            '<div class="input-group mb-2" data-toggle="item-container" id="pollsAnswers"><div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-check-square-o"></i> </span></div><input type="text" class="w-50 form-control" name="answers[]" placeholder="<?php echo app('translator')->get('Unesite odgovor'); ?>" value="' + value + '" data-index="4"><input type="text" class="w-10 form-control"name="votes[]" placeholder="<?php echo app('translator')->get('Glasova'); ?>" value="' + votes[index] + '" data-index="5"><div class="input-group-append"><button title="<?php echo app('translator')->get('Obrisi Ogovor'); ?>" class="btn btn-danger" type="button" data-action="remove-item" data-index="6"><i class="fa fa-minus"></i></button><button title="<?php echo app('translator')->get('Dodaj Odgovor'); ?>" class="btn btn-primary" type="button" data-action="add-item" data-index="6"><i class="fa fa-plus"></i></button></div> <span class="d-none form-control"></span>'
                        );
                    } else {
                        $('#poll-answers-container').append(
                            '<div class="input-group mb-2" data-toggle="item-container" id="pollsAnswers"><div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-check-square-o"></i> </span></div><input type="text" class="w-50 form-control" name="answers[]" placeholder="<?php echo app('translator')->get('Unesite odgovor'); ?>" value="' + value + '" data-index="4"><input type="text" class="w-10 form-control"name="votes[]" placeholder="<?php echo app('translator')->get('Glasova'); ?>" value="' + votes[index] + '" data-index="5"><div class="input-group-append"><button title="<?php echo app('translator')->get('Obrisi Ogovor'); ?>" class="btn btn-danger" type="button" data-action="remove-item" data-index="6"><i class="fa fa-minus"></i></button><button title="<?php echo app('translator')->get('Dodaj Odgovor'); ?>" class="btn btn-primary" type="button" data-action="add-item" data-index="6"><i class="fa fa-plus"></i></button></div><span class="d-none form-control"></span>')
                    }

                });

                $('#polls-form input[name="date_from"]').val(changeDateForm(entity.date_from));
                $('#polls-form input[name="date_to"]').val(changeDateForm(entity.date_to));
                $('#polls-form input[name="question"]').val(entity.question);
                $('#polls-form input[name="entityId"]').val(entity.id);

            });
            return window['pollsModalInstance'];
        };
        //BRISANJE SELECT-a I FORMINIH INPUTA U MODALU
        function clearModal(){
            $('#pollsModal #polls-form input').val('');
            $('#polls-form').attr('style', 'display:none;');
            $('#select-polls').attr('style', 'display:none;');
            $('#pollsModal [name="old-poll"]').attr('data-id', '');
            $('#pollsModal select[name="polls-intexts"] option').remove();
            if($('#polls-form input').hasClass('is-valid')){
                $('#polls-form input').removeClass('is-valid');
            }
            if($('#polls-form input').hasClass('is-invalid')){
                $('#polls-form input').removeClass('is-invalid');
                $('#polls-form input').next('div .text-danger').text("");
            }
            $('#poll-answers-container').html(
                '<div class="input-group mb-2" data-toggle="item-container" id="pollsAnswers"><div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-check-square-o"></i> </span></div><input type="text" class="w-50 form-control" name="answers[]" placeholder="<?php echo app('translator')->get('Unesite odgovor'); ?>" value="" data-index="4"><input type="text" class="w-10 form-control"name="votes[]" placeholder="<?php echo app('translator')->get('Glasova'); ?>" value="1" data-index="5"><div class="input-group-append"><button title="<?php echo app('translator')->get('Obrisi Ogovor'); ?>" class="btn btn-danger" type="button" data-action="remove-item" data-index="6"><i class="fa fa-minus"></i></button><button title="<?php echo app('translator')->get('Dodaj Odgovor'); ?>" class="btn btn-primary" type="button" data-action="add-item" data-index="6"><i class="fa fa-plus"></i></button></div> <span class="d-none form-control"></span>'
            );
        };

        //IZMENI FORMAT DATUMA POSTOJECE ANKETE
        function changeDateForm(date){
            let dateParts = date.split('-');
            let newParts = dateParts[0] + '-' + dateParts[1] + '-' + dateParts[2];
            return newParts;
        };

        $(document).ready(function () {


            $('.article-modals [name="date_from"]').datepicker({format: 'yyyy-mm-dd'});
            $('.article-modals [name="date_to"]').datepicker({format: 'yyyy-mm-dd'});
            $('.article-modals #poll-answers-container').multiItemsControl({});

            //PRIKAZI SELECT POSTOJECIH ANKETA
            $('#pollsModal #show-polls').on('click', function(e){
                clearModal();
                $('#select-polls').attr('style', 'display:show;');
                $('#polls-form').attr('style', 'display:none;');
            });
            //PRIKAZI FORMU U MODALU
            $('#pollsModal #show-form').on('click', function(e){
                clearModal();
                $('#polls-form').attr('style', 'display:show;');
                $('#select-polls').attr('style', 'display:none;');
            });
            
            //POZIV SELECT2
            $('#pollsModal [name="polls-intexts"]').select2({
                ajax: {
                url: "<?php echo e(route('articles.get_poll_intexts')); ?>",
                dataType: 'json',
                type: 'get'
                },
                multiple: false
            });
            //UZMI POSTOJECU ANKETU


            $(document).on("keypress", '#polls-form', function (e) {
                let code = e.keyCode || e.which;
                if (code == 13) {
                    e.preventDefault();
                }
            });
            $('#polls-form').on('click', '[data-action="add-item"]', function(e){
                $('#polls-form').find('input[name="votes[]"]').last().val(1);
            });
        });
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/articles/partials/modals/polls.blade.php ENDPATH**/ ?>