
<?php $__env->startPush('head_links'); ?>
    <link href="<?php echo e(asset('/custom/ckeditor/contents.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopPush(); ?>
<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
      <?php echo csrf_field(); ?>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Naziv Autora'); ?><sup>*</sup></label>
        <div class="col-sm-9">
            <input 
                type="text" 
                class="form-control <?= $errors->has("name") ? 'is-invalid' : ""; ?>" 
                name="name" 
                placeholder="<?php echo app('translator')->get('Naziv'); ?>" 
                value="<?php echo e(old('name', $entity->name)); ?>"
                data-index="1"
            >
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Biografija'); ?></label>
        <div class="col-sm-9">
            <textarea id="contentEditor" name="biography" class="form-control <?= $errors->has("biography") ? 'is-invalid' : ""; ?>" rows="5"><?php echo e(old('biography', $entity->biography)); ?></textarea>
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'biography'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Slika'); ?></label>
        <div class="col-sm-9">
            <input 
                type="file" 
                class="form-control filestyle <?= $errors->has("photo") ? 'is-invalid' : ""; ?>" 
                name="photo" 
                placeholder="<?php echo app('translator')->get('Slika'); ?>"
                data-index="3"
            >
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'photo'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <?php if($entity->image): ?>
    <div class="form-group row">
        <label class="col-sm-3 control-label"><?php echo app('translator')->get('Prikaz Slike'); ?></label>
        <div class="col-sm-9">
        <img src="<?php echo e($entity->getImageUrl()); ?>" width="450" height="450">
        </div>
    </div>
    <?php endif; ?>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light" id="button" data-index="4">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>

<?php $__env->startPush('footer_scripts'); ?>
<script type="text/javascript" src="<?php echo e(url('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/custom/ckeditor/ckeditor.js')); ?>"></script>
<script src="<?php echo e(asset('/custom/ckeditor/adapters/jquery.js')); ?>"></script>
<script>

    $(document).ready(function(){

        $('#contentEditor').ckeditor({
            height: '400px',
            bodyId: 'article_content',
            bodyClass: 'news-content single-news single-news-content',
            extraPlugins: 'pastetext,news,socialembed',
            toolbar: [
                {name: 'document', groups: ['mode', 'doctools'], items: ['Source', '-', 'Templates']},
                {
                    name: 'clipboard',
                    groups: ['clipboard', 'undo', 'cleanup'],
                    items: ['Cut', 'Copy', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo', '-', 'RemoveFormat']
                },
                {name: 'basicstyles', groups: ['basicstyles'], items: ['Bold', 'Italic', 'Underline', 'Strike']},
                {
                    name: 'paragraph',
                    groups: ['list', 'indent', 'align'],
                    items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']
                },
                {name: 'links', items: ['Link', 'Unlink']},
                {name: 'styles', items: ['Format']},
                {name: 'colors', items: ['TextColor', 'BGColor']},
                {name: 'tools', items: ['ShowBlocks', 'Maximize']},
                {name: 'insert', items: ['Image']}

            ],
            forcePasteAsPlainText: true,
            allowedContent: true,
            contentsCss: [
                '/custom/ckeditor/skins/moono/editor.css',
                '/custom/ckeditor/single-news.css',
                '/custom/ckeditor/single-news-custom.css',
            ]
        });

    });
$('#entity-form').validate({
    "rules": {
        "name": {
            required: true,
            maxlength: 50
        },
        "biography": {
            required: false,
            maxlength: 65000
        }
    }
});
$(document).on("keypress", 'form', function (e) {
    let code = e.keyCode || e.which;

    let $this = $(e.target);
    let index = parseFloat($this.attr('data-index'));
    
    if (code == 13) {

        e.preventDefault();

        if($this.attr('type') == 'submit'){
            $this.click();
        }

        let input = $('[data-index="' + (index + 1).toString() + '"]');

        input.focus();

        if(input.attr('type') == 'file'){
            input.click();

        }
        
    }
});

</script>

<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/authors/partials/form.blade.php ENDPATH**/ ?>