<?php

namespace App\Http\Controllers;

//change the request class if needed
use Illuminate\Http\Request as Request;

use App\Models\Truck\Procurement as Entity;
use App\Models\Website\Website;

use App\Models\Truck\InvoicePayment;
use App\Models\Truck\ProcurementPayment;

use Junges\ACL\Models\Group;

use App\Http\Resources\Select2\Role;
use Illuminate\Validation\Rule;

use App\Http\Resources\JsonResource;
use App\Models\Truck\CompanyProcurement;
use App\Models\Truck\Driver;
use App\Models\Truck\Truck;
use Illuminate\Support\Carbon;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class ProcurementController extends Controller 
{
    protected $request;
    
    public function __construct(Request $request)
    {
        $this->request = $request;

    }
    
    public function index()
    {   
        $sum = $this->getSummary();

        return view('truck.procurement.index', ['sum' => $sum]);
    }
    
    /*
     * Yajrabox datatables metod
     */
    public function datatable()
    {
        $query = Entity::query()->where('id', '>', 0)->orderBy('created_at', 'desc');

        return datatables($query)
            ->addColumn('actions', function ($entity) {
                return view('truck.procurement.partials.table.actions', 
                            ['entity' => $entity]);
            })
            ->editColumn('debt', function ($entity) {
                return $entity-> debt . ' ' . $entity->currency;
            })->editColumn('company', function ($entity) {
                $company = CompanyProcurement::withTrashed()->where('id', $entity->company)->first();    
                return $company['name']; 
            })->editColumn('paids', function ($entity) {
                return view('truck.procurement.partials.table.paid_actions', 
                            ['entity' => $entity]);
            })->editColumn('date_start',function($entity){
                $date = Carbon::parse($entity->date_start);
                return $date->format('d-m-Y');
            })->editColumn('date_end',function($entity){
                $date = Carbon::parse($entity->date_end);
                return $date->format('d-m-Y');
            })->rawColumns(['actions'])
            ->setRowAttr([
                'data-id' => function($entity) {
                    return $entity->id;
                }
            ])
            ->make(true);
    }
    
    public function create()
    {   
        $entity = new Entity();

        $companies = CompanyProcurement::all();
        
        return view('truck.procurement.create', [
            'entity' => $entity,
            'companies' => $companies,
        ]);
    }
    
    public function store()
    {   
        $request = $this->request;
        $data = $request->validate([
            'id_invoice' => ['required', 'string', 'max:190'],
            'company' => ['required', 'integer', 'exists:truck_companies_procurement,id'],
            'date_start' => ['required', 'string', 'date_format:d-m-Y'],
            'date_end' => ['required', 'string', 'date_format:d-m-Y', 'after_or_equal:date_start'],
            'price' => ['required', 'string', 'max:20'],
            'currency' => ['required', 'string', 'max:20'],
            'text' => ['required', 'string', 'max:900']

        ]);
        $data['date_start'] = date('Y-m-d',strtotime(request()->date_start));
        $data['date_end'] = date('Y-m-d',strtotime(request()->date_end));

        $entity = new Entity();
        
        $entity->fill($data);
        
        $entity->save();

        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Faktura je uspešno sačuvana!'));
        }
        
        return redirect()->route('truck.procurement')->withSystemSuccess(__('Faktura je uspešno sačuvana!'));
    }
    
    public function edit(Entity $entity)
    {
        $companies = CompanyProcurement::all();

        return view('truck.procurement.edit', [
            'entity' => $entity,
            'companies' => $companies,
        ]);
    }
    
    public function update(Entity $entity)
    {
        $request = $this->request;
        
        $data = $request->validate([
            'id_invoice' => ['required', 'string', 'max:190'],
            'company' => ['required', 'integer', 'exists:truck_companies_procurement,id'],
            'date_start' => ['required', 'string', 'date_format:d-m-Y'],
            'date_end' => ['required', 'string', 'date_format:d-m-Y', 'after_or_equal:date_start'],
            'price' => ['required', 'string', 'max:20'],
            'currency' => ['required', 'string', 'max:20'],
            'text' => ['required', 'string', 'max:900']
        ]);

        $data['date_start'] = date('Y-m-d',strtotime(request()->date_start));
        $data['date_end'] = date('Y-m-d',strtotime(request()->date_end));
        
        $entity->fill($data);
        
        $entity->save();

        if ($request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Faktura je uspešno izmenjena!'));
        }
        
        return redirect()->route('truck.procurement')->withSystemSuccess(__('Faktura je uspešno izmenjena!'));
    }
    
    public function delete(Entity $entity)
    {
        $entity->delete();
        
        if ($this->request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Faktura je uspešno obrisana!'));
        }
        
        return redirect()->route('truck.procurement.index')->withSystemSuccess(__('Faktura je uspešno obrisana!'));
    }

    public function paid(Entity $entity)
    {
        $entity = Entity::where('id', request()->id)->first();

        if(request()->isFullPayment == "true"){
            $entity->status = 1;
            $entity->price_part =0;
            $entity->date_done =  Carbon::now();

            ProcurementPayment::create([
                'company' => $entity->company,
                'price' => $entity->debt,
                'currency' => $entity->currency,
                'date_start' => Carbon::now(),
                'reference' => null,
            ]);

            $entity->update();
        }

        if(request()->isFullPayment == "false"){
            $entity->price_part = $entity->price_part + request()->enteredAmount;

            if($entity->price_part == $entity->price){
                $entity->status = 1;
                $entity->price_part =0;
                $entity->date_done =  Carbon::now();
            }

            if($entity->price_part == $entity->price){
                ProcurementPayment::create([
                    'company' => $entity->company,
                    'price' => $entity->price,
                    'currency' => $entity->currency,
                    'date_start' => Carbon::now(),
                    'reference' => null,
                ]);
            }else{
                ProcurementPayment::create([
                    'company' => $entity->company,
                    'price' => request()->enteredAmount,
                    'currency' => $entity->currency,
                    'date_start' => Carbon::now(),
                    'reference' => null,
                ]);
            }

            $entity->update();
            
        }

        if ($this->request->wantsJson()) {
            return JsonResource::make()->withSuccess(__('Potvrda placanja je uspešno sacuvana!'));
        }
        
        return redirect()->route('truck.procurement.index')->withSystemSuccess(__('Potvrda placanja je uspesno sacuvana!'));

    }

    public function getSummary()
    {
        // Izračunavanje ukupnog dugovanja za fakture sa statusom 0
        $pendingEur = Entity::where('status', 0)->where('currency', 'EUR')->sum('debt'); // Pretpostavimo da je iznos u eur polje eur_amount
        $pendingKm = Entity::where('status', 0)->where('currency', 'KM')->sum('debt'); // Pretpostavimo da je iznos u km polje km_amount

        // Kreiranje odgovora
        $response = [
            'pending' => [
                'eur' => $pendingEur,
                'km' => $pendingKm
            ],
            'paid' => [
                'eur' => 0, // Zamijenite stvarnim podacima ako imate
                'km' => 0   // Zamijenite stvarnim podacima ako imate
            ]
        ];

        return response()->json($response);
    }

}
