<?php

namespace App\Http\Requests\Admin;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class BannersRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required', 'string', 'max:100'],
            'banner_position_id' => ['required', 'numeric', 'exists:banner_positions,id'], 
            'date_start' => ['required', 'string', 'date_format:Y-m-d'], 
            'date_end' => ['required', 'string', 'date_format:Y-m-d', 'after_or_equal:date_start'], 
            'categories' => ['nullable','required_without:subcategories', 'array', 'min:1'],
            'categories.*' => ['nullable', 'string'],
            'subcategories' => ['nullable','required_without:categories', 'array', 'min:1'],
            'subcategories.*' => ['nullable', 'numeric'],
            'show_on_sensitive' => ['required', 'numeric', 'in:0,1'], 
            'adcode' => ['required', 'string', 'max:6000'],
            'priority' => ['nullable', 'numeric', 'min:1', 'max:9'],
        ];
    }
}
