<?php

namespace App\Providers;

use App\Services\LockResourceService;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;

use Illuminate\Support\Facades\Schema;

use App\Services\NbsService;
use App\Services\PoslovnaGodinaService;
use App\Services\RobnoDokument\DokumentService;
use App\Services\RobnoKnjizenje\RobnoKnjizenjeService;
use App\Services\RobnoKontiranje\RobnoKontiranjeService;
use App\Services\Finansije\FinansijeService;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        Relation::morphMap([
            'videos' => 'App\Models\Videos\BridVideo'
        ]);
    }
    
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        
        // REGISTRUJ SERVIS ZA ZAKLJUCAVANJE RESURSA
        $this->app->bind(LockResourceService::class, function($app) {
            return new LockResourceService();
        });

        $this->app->alias(LockResourceService::class, 'lock');
        
    }
}
