<?php

namespace App\Rules;

use App\Models\Category;
use Illuminate\Contracts\Validation\Rule;

/**
 * Sprecava stvaranje kategorije 3+ nivoa.
 */
class SubcategoryLevelRule implements Rule
{
    /**
     * Proveri da li roditeljska kategorija ima svoju roditeljsku kategoriju. 
     * Ukoliko ima, to znaci da bi kreirana kategorija bila 3+ niva sto nije 
     * dozvoljeno.
     *
     * @param  string  $attribute
     * @param  integer $parentCategoryId
     * @return bool
     */
    public function passes($attribute, $parentCategoryId)
    {
        $parentCategory = Category::findOrFail($parentCategoryId);

        if($parentCategory->parent_id != Category::PARENT_ID_NO_PARENT) {
            return FALSE;
        }

        return TRUE;
    }

    /**
     * Poruka greske prilikom neuspesne validacije.
     *
     * @return string
     */
    public function message()
    {
        return __('Podkategorija moze biti samo drugog nivoa!');
    }
}
