CKEDITOR.dialog.add( 'socialembedDialog', function ( editor ) {
    return {
    	title: 'Social Embed Code',
        minWidth: 400,
        minHeight: 200,
        onShow: function() {
			// Try to detect socialembed div
        	this.fakeElement = this.element = null;
        	
			var fakeElement = this.getSelectedElement();
			if ( fakeElement && fakeElement.data( 'cke-real-element-type' ) && fakeElement.data( 'cke-real-element-type' ) == 'socialembed' ) {
				this.fakeElement = fakeElement;
				this.element = editor.restoreRealElement(fakeElement);
				
				this.setupContent(this.element);
			} else {
				var element = editor.document.createElement('div');
				element.setAttribute('class', 'embed-responsive');
				element.setAttribute('data-socialembed', 'default');
				this.element = element;
			};
        },
        onOk: function() {
            var element = this.element;
            this.commitContent(element);
            
            var fakeElement = editor.createFakeElement(element, 'cke_socialembed', 'socialembed', false);
            var elementHtml = element.getHtml();
			if (elementHtml.match(/youtube/)) {
				fakeElement.setAttribute('socialembed', 'youtube');
			} else if (elementHtml.match(/facebook/)) {
				fakeElement.setAttribute('socialembed', 'facebook');
			} else if (elementHtml.match(/twitter/)) {
				fakeElement.setAttribute('socialembed', 'twitter');
			} else if (elementHtml.match(/instagram/)) {
				fakeElement.setAttribute('socialembed', 'instagram');
			} else {
				fakeElement.setAttribute('socialembed', 'default');
			}
			
			if (this.fakeElement) {
				fakeElement.replace( this.fakeElement );
				editor.getSelection().selectElement(fakeElement);
			} else {
				editor.insertElement(fakeElement);
			}
        },
        contents: [
            {
                id: 'socialembed-dialog-tab',
                label: 'Embed Code',
                elements: [
                    {
                        type:           'textarea',
                        label:          'Embed Code',
                        id:             'socialembedCode',
                        rows:			10,
			'inputStyle' : 'white-space: normal;',
                        'default':      '',
                    	validate: CKEDITOR.dialog.validate.notEmpty('You must enter embed code!'),
                    	setup: function(element) {
                            this.setValue(element.getHtml());
                        },
                        commit: function (element) {
                            var elementHtml = this.getValue();
                            element.setHtml(elementHtml);
                            if (elementHtml.match(/youtube/)) {
                            	element.setAttribute('data-socialembed', 'youtube');
							} else if (elementHtml.match(/facebook/)) {
								element.setAttribute('data-socialembed', 'facebook');
							} else if (elementHtml.match(/twitter/)) {
								element.setAttribute('data-socialembed', 'twitter');
							} else if (elementHtml.match(/instagram/)) {
								element.setAttribute('data-socialembed', 'instagram');
							} else {
								element.setAttribute('data-socialembed', 'default');
							}
                        }
                    }
                ]
            }
        ]
    };
});
