/*
* Embed Media Dialog based on http://www.fluidbyte.net/embed-youtube-vimeo-etc-into-ckeditor
*
* Plugin name:      mediaembed
* Menu button name: MediaEmbed
*
* Youtube Editor Icon
* http://paulrobertlloyd.com/
*
* @author Fabian Vogelsteller [frozeman.de]
* @version 0.5
*/
( function() {
	CKEDITOR.plugins.add( 'socialembed', {
		requires: 'dialog,fakeobjects',
		icons: 'socialembed', // %REMOVE_LINE_CORE%
		hidpi: true, // %REMOVE_LINE_CORE%
		onLoad: function() {
			CKEDITOR.addCss( 'img.cke_socialembed {' +
					'background-image: url(' + CKEDITOR.getUrl( this.path + 'images/default.jpg' ) + ');' +
					'background-position: center center;' +
					'background-repeat: no-repeat;' +
					'width: 770px;' +
					'height: 50px;' +
				'}' +
				'img.cke_socialembed[socialembed="youtube"] {' +
					'background-image: url(' + CKEDITOR.getUrl( this.path + 'images/youtube.jpg' ) + ');' +
				'}' +
				'img.cke_socialembed[socialembed="facebook"] {' +
					'background-image: url(' + CKEDITOR.getUrl( this.path + 'images/facebook.jpg' ) + ');' +
				'}' +
				'img.cke_socialembed[socialembed="twitter"] {' +
					'background-image: url(' + CKEDITOR.getUrl( this.path + 'images/twitter.jpg' ) + ');' +
				'}' +
				'img.cke_socialembed[socialembed="instagram"] {' +
					'background-image: url(' + CKEDITOR.getUrl( this.path + 'images/instagram.jpg' ) + ');' +
				'}'
			);

		},
		init: function(editor) {
			var socialembedPlugn = this;
			var deletableTags = ['img'];

            editor.addCommand( 'SocialEmbed', new CKEDITOR.dialogCommand( 'socialembedDialog' ) );
			CKEDITOR.dialog.add( 'socialembedDialog', this.path + 'dialogs/socialembed.js' );
			
			editor.addCommand('deleteLatestEmbedResponsive', {
            	exec: function(editor) {
            		var selectedElement = editor.getSelection().getStartElement();
            		if (!selectedElement) {
            			return;
            		}
					var elementParents = selectedElement.getParents();
            		var elementParentLatestDiv = null;
            		for (var elementParentIndex in elementParents) {
            			if (deletableTags.indexOf(elementParents[elementParentIndex].getName()) >= 0) {
            			// if (elementParents[elementParentIndex].getName() == 'aside') {
            				elementParentLatestDiv = elementParents[elementParentIndex];
            				break;
            			}
            		}
        			if (!elementParentLatestDiv) {
        				return;
        			}
        			
        			elementParentLatestDiv.remove();
        			editor.focus();
            	}
            });
            
            editor.ui.addButton( 'SocialEmbed', {
                label: 'Social Embed Code',
                command: 'SocialEmbed',
                icon: 'socialembed',
                toolbar: 'socialembed'
            });

			editor.on('doubleclick', function(evt) {
				var element = evt.data.element;

				if (element.is( 'img' ) && element.data('cke-real-element-type') == 'socialembed') {
					evt.data.dialog = 'socialembedDialog';
				}
			} );
            
            if (editor.contextMenu) {
            	editor.addMenuGroup('socialembed');

        		editor.contextMenu.addListener(function(element, selection) {
        			if (element.hasAttribute('socialembed')) {

        	            editor.contextMenu.removeAll();
        	            editor.addMenuItems({
        	            	SocialEmbed: {
        	                    label : 'Izmeni Social Embed Code',
        	                    icon: 'socialembed',
        	                    command : 'SocialEmbed',
        	                    group : 'socialembed',
        	                    order : 1
							},
							DeleteLatestDiv: {
        	                    label : 'Obriši okvir',
        	                    command : 'deleteLatestEmbedResponsive',
        	                    group : 'socialembed',
        	                    order : 2
        					}
        	            });

            			return {
							SocialEmbed: CKEDITOR.TRISTATE_ON,
							DeleteLatestDiv: CKEDITOR.TRISTATE_ON
                        };

        			} else if (selection.getType() == CKEDITOR.SELECTION_NONE || selection.getType() == CKEDITOR.SELECTION_TEXT) {
        				editor.addMenuItems({
        					SocialEmbed: {
        	                   label : 'Ubaci Social Embed Code',
        	                   icon: 'socialembed',
        	                   command : 'SocialEmbed',
        	                   group : 'socialembed',
        	                   order : 100
        					}
        	            });

            			return {
            				SocialEmbed: CKEDITOR.TRISTATE_OFF
                        };
        			}
                });
        	}
        },
        afterInit: function( editor ) {
			var dataProcessor = editor.dataProcessor,
				dataFilter = dataProcessor && dataProcessor.dataFilter;

			if ( dataFilter ) {
				dataFilter.addRules( {
					elements: {
						'div': function(element) {
							var attributes = element.attributes,
								socialembed = attributes['data-socialembed'] && String(attributes['data-socialembed']).toLowerCase();

							if (!socialembed) {
								return null;
							}
							
							var fakeElement = editor.createFakeParserElement( element, 'cke_socialembed', 'socialembed', false);
							
							var elementHtml = element.getHtml();
							if (elementHtml.match(/youtube/)) {
								fakeElement.attributes.socialembed = 'youtube';
							} else if (elementHtml.match(/facebook/)) {
								fakeElement.attributes.socialembed = 'facebook';
							} else if (elementHtml.match(/twitter/)) {
								fakeElement.attributes.socialembed = 'twitter';
							} else if (elementHtml.match(/instagram/)) {
								fakeElement.attributes.socialembed = 'instagram';
							} else {
								fakeElement.attributes.socialembed = 'default';
							}
							
							return fakeElement;
						}
					}
				}, 5 );
			}
		}
    });
})();
