/*
export const maxTagsRule = {
    message(field, maxCount, data) {
        // field maps to <input name="field">
        console.log('field', field);
        console.log('maxCount', maxCount[0]);
        console.log('data', data);
        return (data && data.message) || `Number of ${field} must be ${maxCount[0]} or less`;
    },
    validate(tags, maxCount) {
        console.log('tags', tags, 'maxCount', maxCount[0]);
        if (tags.length <= maxCount[0]) {
            console.log(`max ${maxCount[0]}, actual ${tags.length}`);
            return true;
        }
        return false;
    },
};

export const minTagsRule = {
    message(field, minCount, data) {
        // field maps to <input name="field">
        console.log('field', field);
        console.log('minCount', minCount[0]);
        console.log('data', data);
        return (data && data.message) || `Number of ${field} must be ${minCount[0]} or more`;
    },
    validate(tags, minCount) {
        console.log('tags', tags, 'minCount', minCount[0]);
        if (tags.length >= minCount[0]) {
            console.log(`max ${minCount[0]}, actual ${tags.length}`);
            return true;
        }
        return false;
    },
};
*/

var customRules = {
    'maxTags': { 
        validate: function(tags, _a) {
            let maxCount = _a.maxCount;
            //console.log('tags', tags, 'maxCount', maxCount[0]);
            if (tags.length <= maxCount[0]) {
                //console.log(`max ${maxCount[0]}, actual ${tags.length}`);
                return true;
            }
            return false;
        },
        params: [
            {
                name: 'maxCount'
            }
        ]
    },
    'minTags': {
        validate: function(tags, _a) {
            let minCount = _a.minCount;
            //console.log('tags', tags, 'minCount', minCount[0]);
            if (tags.length >= minCount[0]) {
                //console.log(`max ${minCount[0]}, actual ${tags.length}`);
                return true;
            }
            return false;
        },
        params: [
            {
                name: 'minCount'
            }
        ]
    }
};

var customRulesMessages = {
    'maxTags': {
        en: `Number of {_field_} must be {maxCount} or less`,
        sr_Latin: `Broj elemenata {_field_} mora biti {maxCount} ili manje`
    },
    'minTags': {
        en: `Number of {_field_} must be {minCount} or more`,
        sr_Latin: `Broj elemenata {_field_} mora biti {minCount} ili više`
    },
}

export {customRules, customRulesMessages};
