@push('head_links')
    <link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
    <style>
        .newscms-edit-title {
            position: absolute; top: 0%;
        }
        .newscms-edit-submit {
            position: absolute; bottom: 5%;
        }
    </style>
@endpush

<form action="{{ route('profile.edit') }}" method="post" id="edit_profila_form" class="contact-form" enctype="multipart/form-data" autocomplete="off">
    @csrf

    <div class="row newscms-edit-title">
        <div class="col-12">
            <div class="h4">
                Izmena profilnih podataka
            </div>
        </div> 
    </div>

    <div class="row">

        <div class="col-12">
            <div class="form-group">
                <label for="fname">{{ __('Ime') }}</label>
                <input class="form-control @errorClass('first_name', 'is-invalid')" 
                        id="fname" 
                        name="first_name" 
                        placeholder="{{ __('Ime') }}" 
                        type="text" 
                        value="{{ old('first_name', auth()->user()->first_name) }}" 
                        required
                        >
                @formError(['field' => 'first_name'])
            </div>

            <div class="form-group">
                <label for="lname">{{ __('Prezime') }}</label>
                <input class="form-control @errorClass('last_name', 'is-invalid')" 
                        id="lname" 
                        name="last_name" 
                        placeholder="{{ __('Prezime') }}" 
                        type="text" 
                        value="{{ old('last_name', auth()->user()->last_name) }}"
                        required
                        >
                @formError(['field' => 'last_name'])
            </div>

            <div class="form-group">
                <label for="phone">{{ __('Telefon') }}</label>
                <input class="form-control @errorClass('phone', 'is-invalid')" 
                        id="phone" 
                        name="phone" 
                        placeholder="{{ __('Telefon') }}" 
                        type="text" 
                        value="{{ old('phone', auth()->user()->phone) }}"
                        required
                        >
                @formError(['field' => 'phone'])
            </div>

            <div class="form-group">
                <label for="email">{{ __('Imejl') }}</label>
                <input class="form-control @errorClass('email', 'is-invalid')" 
                        id="email" 
                        name="email" 
                        type="email" 
                        placeholder="{{ __('Imejl') }}" 
                        value="{{ old('email', auth()->user()->email) }}" 
                        required
                        >
                @formError(['field' => 'email'])
            </div>

        </div> 

        <div class="col-1">
        </div>

        <div class="col-6">
            {{-- @include('profile.partials.form.profile_image', ['entity' => auth()->user()]) --}}
        </div>
    </div>
    
    <div class="row newscms-edit-submit">
        <div class="col-12">
            <div class=""> 
                <button type="submit" class="btn btn-success" id="send">@lang('Izmeni podatke')</button>
            </div>
        </div> 
    </div>

</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
<script>
$(function() {

    var blade = {
        "edit_password_url": "{{ route('profile.edit_password') }}"
    }

    // FRONTEND VALIDACIJA
    $('#edit_profila_form').validate({
        rules: {
            first_name:{
               required: true
            },
            last_name:{
               required: true
            },
            phone:{
            },
            email: {
                required: true,
                email: true
            }
        }
    });

    /* Izmena lozinke <button> click event */
    $('#edit_lozinku_btn').on('click', function() {
        window.location = blade.edit_password_url;
    });  

});
</script>
@endpush
