@if($entity->status == 0)
<div class="btn-group">
    <button 
            type="button"
            class="btn btn-success"
            title="@lang('Potvrdi placanje')"
            data-title="@lang('Potvrdi placanje')"
            data-action="delete"
            data-id="{{$entity->id}}"
            data-text="Da li ste sigurni da želite da potvrdite placanje fakture #~b~#"
            data-label="{{$entity->id_invoice}}"
            data-ajax-url="{{route('truck.invoices_procurement_paid', ['entity' => $entity->id])}}"
        >
            Potvrdi placanje
    </button>
</div>
@else
    @if($entity->date_done)
    <div class="btn-group">
        <button 
                type="button"
                class="btn btn-light"
                disabled
            >
            {{ \Carbon\Carbon::parse($entity->date_done)->format('d-m-Y') }}
            </button>
    </div>
    @endif
@endif

<div class="btn-group">
    <button type="button" class="btn btn btn-outline-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        Opcije
    </button>
    <div class="dropdown-menu">
        <a 
            href="{{ route('truck.invoices_procurement_edit', ['entity' => $entity->id]) }}" 
            class="dropdown-item btn btn-warning"
            title="@lang('Izmeni')"
        >
            <i class="fa fa-pencil"></i> Izmeni
        </a>
        <button 
            type="button"
            class="dropdown-item btn btn-danger"
            title="@lang('Obriši')"
            data-title="@lang('Obriši')"
            data-action="delete"
            data-id="{{ $entity->id }}"
            data-text="Da li ste sigurni da želite da obrišete fakturu #~b~#"
            data-label="{{ $entity->id_invoice }}"
            data-ajax-url="{{ route('truck.invoices_procurement_delete', ['entity' => $entity->id]) }}"
        >
            <i class="fa fa-trash"></i> Obriši
        </button>
        <button 
            type="button"
            class="dropdown-item btn btn-info"
            title="@lang('Pregled')"
            onclick="showProcurementInvoice({{ $entity->id }})"
        >
            <i class="fa fa-file-text-o"></i> Pregled fakture
        </button>
    </div>
</div>
<script>
    function showProcurementInvoice(invoiceId) {
        // Generišemo URL koristeći imenovanu rutu
        var invoiceUrl = "{{ route('truck.invoices_procurement.A4View', ['id' => 'INVOICE_ID_PLACEHOLDER']) }}".replace('INVOICE_ID_PLACEHOLDER', invoiceId);
        document.getElementById('invoiceFrame').src = invoiceUrl;
        $('#invoiceProcurementModal').modal('show');
    }
</script>