@extends('_layout.layout')

@section('head_title', __('Vozila') . ' - ' . __('Vozila'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Vozila"),
    'breadcrumbs' => [
        route('truck.trucks') => __('Vozila')
    ]
])

<style>
    .date-highlight {
        padding: 5px;
        border-radius: 5px;
        display: inline-block;
    }
    
    .date-red {
        background-color: red;
        color: white;
    }
    
    .date-yellow {
        background-color: yellow;
        color: black;
    }
    
</style>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Lista Vozila')</h3>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('truck.trucks_create')}}" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        @lang('Dodaj')
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table">
                        <thead>
                            <tr>
                                <th class="">@lang('')</th>
                                <th class="">@lang('Proizvodjač')</th>
                                <th class="">@lang('Naziv Vozila')</th>
                                <th class="">@lang('Tablice')</th>
                                <th class="">@lang('Registracija')</th>
                                <th class="">@lang('Sestomesecni')</th>
                                <th class="">@lang('PP Aparati')</th>
                                <th class="">@lang('Tahograf')</th>
                                <th class="disabled-sorting text-right">@lang('Opcije')</th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('footer_scripts')
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl:"@route('truck.trucks_datatable')"
    };
    
    // DATATABLES
    $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "image", orderable: false, searchable: false, "className": ""},
            {"data": "producer", "className": ""},
            {"data": "name", "className": ""},
            {"data": "number_of_plates", "className": ""},
            {"data": "registracija_end", "className": ""},
            {"data": "sestomjesecni_end", "className": ""},
            {"data": "pp_end", "className": ""},
            {"data": "tahograf_end", "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
       "order": [[0, "asc"]],
        "rowCallback": function(row, data, index) {
            var today = moment();

            function applyDateHighlight(columnIndex, dateStr) {
                var dateEnd = moment(dateStr, 'DD-MM-YYYY'); 
                var cell = $('td:eq(' + columnIndex + ')', row);

                cell.find('.date-highlight').removeClass('date-red date-yellow');
                if (today.isSameOrAfter(dateEnd, 'day')) {
                    console.log('2233');
                    cell.html('<span class="date-highlight date-red">' + dateStr + '</span>');
                } else if (today.isSameOrAfter(dateEnd.clone().subtract(7, 'days'), 'day')) {
                    console.log('4455');
                    cell.html('<span class="date-highlight date-yellow">' + dateStr + '</span>');
                } else {
                    console.log('6677');
                    cell.html(dateStr);
                }
            }

            applyDateHighlight(4, data.registracija_end);
            applyDateHighlight(5, data.sestomjesecni_end);
            applyDateHighlight(6, data.pp_end);
            applyDateHighlight(7, data.tahograf_end);
        },
        "initComplete": function() {
            $('[data-toggle="tooltip"]').tooltip();
        }
    });


    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

});
</script>
@endpush