@extends('_layout.layout')

@section('head_title', __('Korisnici') . ' - ' . __('Korisnici Programa'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Korisnici"),
    'breadcrumbs' => [
        route('users.index') => __('Korisnici Programa')
    ]
])

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Lista Korisnika')</h3>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('users.create')}}" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        @lang('Dodaj')
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table">
                        <thead>
                            <tr>
                                <th class="">@lang('Ime')</th>
                                <th class="">@lang('Prezime')</th>
                                <th class="">@lang('Email')</th>
                                <th class="">@lang('Telefon')</th>
                                <th class="disabled-sorting text-right">@lang('Opcije')</th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('footer_scripts')
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl:"@route('users.datatable')"
    };
    
    // DATATABLES
    $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "first_name", "className": ""},
            {"data": "last_name", "className": ""},
            {"data": "email", "className": ""},
            {"data": "phone", "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]]
    });
    
    
    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

});
</script>
@endpush