<div class="card">
    <div class="card-heading d-flex justify-content-between">
        <div class="card-heading-title">
            <h3 class="card-title"><?php echo app('translator')->get('Lista autora'); ?></h3>
            <p class="card-sub-title text-muted"><?php echo app('translator')->get('Postoji <code>pretraga</code> liste'); ?></p>
        </div>
        <div class="card-heading-actions">
            
        </div>
    </div>
    <div class="card-body">
        <table id="entities-table" class="table table-striped">
            <thead>
                <tr>
                    <th class="text-center"><span class="text-success"><i class="fa fa-check"></i></span></th>
                    <th><?php echo app('translator')->get('Naziv Autora'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Akcije'); ?></th>
                </tr>
            </thead>

        </table>
    </div>
</div>

<?php $__env->startPush('footer_scripts'); ?>
<script>
$(function(){

    $('#entities-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: "<?= route('authors.datatable'); ?>",
            type: "POST",
            data: {entityId: "<?php echo e($entity->id); ?>"}
        },
        "columns": [
            {"data": "ban", className: "text-center"},
            {"data": "name"},
            {"data": "actions", "searchebale": false, "orderable": false, className: "text-center"}
        ]
    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="delete"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="enable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="disable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });


});
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/authors/partials/list.blade.php ENDPATH**/ ?>