<?php

namespace App\Http\Controllers\Traits;

use App\Models\Tag as Entity;
use App\Http\Resources\Select2\Tag as Resource;
use App\Http\Resources\JsonResource;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request as Request;

/**
 * Trait is intended to use with 'tagsSelect' jQuery Plugin
 */
trait TagsSelectTrait
{   
    /**
     * This ajax method returns filtered records from 'tags' table
     * 
     * @return JSON
     */
    public function selectTag()
    {   
        $selections = Entity::query()->active();
        
        $request = $this->request;
        
        $data = $request->validate([
            'term' => 'nullable|string',
        ]);
            
        if (! empty($data['term'])) {
            $selections->where(function ($q) use ($data) {
                $s = ['LIKE', '%' . $data['term'] . '%'];
                $q->where(function ($query) use ($s) {
                    $query->where('title', ...$s);
                })
                ;
            });
        }

        $selections = $selections->limit(100)->get();
        if ($selections->isEmpty()) {
            return response()->json(['results' => []]);
        }
        
        return Resource::collection($selections);
    }
    
    /**
     * This ajax method create new record in 'tags' table
     * 
     * @return JSON
     */
    public function createTag()
    {
        $request = $this->request;
        $entity = new Entity();
        
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:121|unique:tags,title,NULL,id,deleted_at,NULL'
        ]);
        
        if($validator->fails()){
            return JsonResource::make($entity)->withError($validator->messages()->first());
        }
        
        $entity->fill(['title' => $request->title]);
        
        $entity->save();
            
        return JsonResource::make([
                'id' => $entity->id,
                'title' => $entity->title
        ])
        ->withSuccess(__('Tag je uspešno sačuvan!'));
    }
    
    /**
     * This ajax method returns most used tags
     * 
     * @return JSON
     */
    protected function mostUsedTags()
    {   
        //SELECT `tag_id`, COUNT(`tag_id`) AS `value_occurrence` FROM `article_tag` GROUP BY `tag_id` ORDER BY `value_occurrence` DESC LIMIT 10;
        $articlesIds = implode(',',array_column(\DB::select('SELECT `id` FROM `articles` WHERE Date(time_created) = CURDATE()'), 'id'));
        
        if($articlesIds != ""){
            $mostUsedTagsIds = \DB::select('SELECT `tag_id`, COUNT(`tag_id`) AS `value_occurrence` FROM `article_tag` WHERE `article_tag`.`article_id` IN ('.$articlesIds.') GROUP BY `tag_id` ORDER BY `value_occurrence` DESC LIMIT 10');
            if(count($mostUsedTagsIds) < 5){
                $mostUsedTagsIds = \DB::select('SELECT `tag_id`, COUNT(`tag_id`) AS `value_occurrence` FROM `article_tag` GROUP BY `tag_id` ORDER BY `value_occurrence` DESC LIMIT 10');
            }
        }else{
            $mostUsedTagsIds = \DB::select('SELECT `tag_id`, COUNT(`tag_id`) AS `value_occurrence` FROM `article_tag` GROUP BY `tag_id` ORDER BY `value_occurrence` DESC LIMIT 10');
        }
        
        if(!empty($mostUsedTagsIds)){
            $mostUsedTagsIds = collect($mostUsedTagsIds)->pluck('tag_id');
            $mostUsedTags = Entity::whereIn('id', $mostUsedTagsIds)->active()->get();
        }else{
            $mostUsedTags = Entity::query()->active();
        
            $request = $this->request;
            $mostUsedTags = $mostUsedTags->take(10)->get();
        }
        
        
        return $mostUsedTags;
    }
    
    
    /**
     * This ajax method returns formated tags
     * 
     * @return JSON
     */
    public function fetchTags(Request $request)
    {   
        $tags = Entity::whereIn('id', $request->value)->get();
        
        return Resource::collection($tags);
    }
}

