<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class PDF extends Model
{

    use SoftDeletes;

    protected $table = 'pdf_files';

    protected $fillable = ['name', 'image', 'file_path'];
    

    const ACTIVE = 1;
    const INACTIVE = 0;

    public function isActive()
    {
        return !$this->ban;
    }

    public function getFileUrl()
    {
        if(empty($this->file_path)){
            return $this;
        }

        $removeParth = '/opt/public';
        
        $parthForURL = str_replace($removeParth, '', $this->file_path);

        $fileUrl = url($parthForURL);
        
        return $fileUrl;
    }

    public function getImageUrl()
    {
        if(empty($this->image)){
            return $this;
        }

        $removeParth = '/opt/public';
        
        $parthForURL = str_replace($removeParth, '', $this->image);

        $imageUrl = url($parthForURL);

        return $imageUrl;
    }
}
